/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.EHorizontalAlignment;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.conqat.lib.simulink.model.datahandler.simulink.MaskObjectParameter;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkElementLayoutUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Rectangle BLOCK_DEFAULT_POSITION = new Rectangle(10, 10, 30, 30);
    private static final Pattern FORMAT_STRING_PLACEHOLDER_PATTERN = Pattern.compile("%<(.*?)>");
    private static final Pattern MASK_VARIABLE_PART_PATTERN = Pattern.compile("(.*)=[@&](\\d+)");

    SimulinkElementLayoutUtils() {
    }

    public static Rectangle extractPosition(SimulinkElementBase element) {
        return SimulinkElementLayoutUtils.extractPosition(element, false);
    }

    public static Rectangle extractPosition(SimulinkElementBase element, boolean needsOldVersionAnnotationAdjustment) {
        if (element instanceof SimulinkModel) {
            return BLOCK_DEFAULT_POSITION;
        }
        String positionString = element.getParameter("Position");
        if (positionString == null) {
            LOGGER.error("No position contained in model for element " + element.getId() + ". Using default position.");
            return BLOCK_DEFAULT_POSITION;
        }
        int[] positionArray = SimulinkUtils.getIntParameterArray(positionString);
        if (positionArray.length == 2) {
            positionArray = Arrays.copyOf(positionArray, 4);
            SimulinkElementLayoutUtils.fixOldVersionAnnotationPositionArray(element, positionArray, true);
        } else if (positionArray.length == 4) {
            if (element instanceof SimulinkAnnotation && needsOldVersionAnnotationAdjustment) {
                SimulinkElementLayoutUtils.fixOldVersionAnnotationPositionArray(element, positionArray, false);
            }
        } else {
            LOGGER.error("Unsupported position array found in model (length = " + positionArray.length + " instead of 4) for element " + element.getId() + ". Using default position.");
            return BLOCK_DEFAULT_POSITION;
        }
        int height = positionArray[3] - positionArray[1];
        int width = positionArray[2] - positionArray[0];
        return new Rectangle(positionArray[0], positionArray[1], width, height);
    }

    private static void fixOldVersionAnnotationPositionArray(SimulinkElementBase element, int[] positionArray, boolean boundsFromText) {
        Rectangle textBounds = new Rectangle(positionArray[2] - positionArray[0] - 4, positionArray[3] - positionArray[1] - 4);
        if (boundsFromText) {
            String text = SimulinkUtils.replaceSimulinkLineBreaks(element.getName());
            FontData font = LayoutHandlerBase.extractFontData(element);
            textBounds = LayoutHandlerBase.determineTextBounds(text, font.getAwtFont());
        }
        EHorizontalAlignment horizontalAlignment = EHorizontalAlignment.parse(element.getParameter("HorizontalAlignment"));
        switch (horizontalAlignment) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                positionArray[0] = positionArray[0] - textBounds.width;
                break;
            }
            default: {
                positionArray[0] = positionArray[0] - (textBounds.width + 4) / 2;
            }
        }
        String verticalAlignment = element.getParameter("VerticalAlignment");
        if (verticalAlignment == null) {
            verticalAlignment = "middle";
        }
        switch (verticalAlignment) {
            case "top": {
                break;
            }
            case "bottom": {
                positionArray[1] = positionArray[1] - textBounds.height;
                break;
            }
            default: {
                positionArray[1] = positionArray[1] - (textBounds.height + 4) / 2;
            }
        }
        positionArray[2] = positionArray[0] + textBounds.width + 4;
        positionArray[3] = positionArray[1] + textBounds.height + 4;
    }

    public static LabelLayoutData extractBlockLabelData(SimulinkBlock block, BlockLayoutData blockLayoutData) {
        String text = block.getNameForLabel();
        FontData font = LayoutHandlerBase.extractFontData(block);
        boolean alternatePlacement = "alternate".equals(block.getParameter("NamePlacement")) || "top".equals(block.getParameter("NameLocation"));
        Point position = SimulinkElementLayoutUtils.calculateBlockLabelPosition(blockLayoutData, LayoutHandlerBase.determineTextBounds(text, font.getAwtFont()), alternatePlacement);
        boolean visible = SimulinkBusUtils.isBusElementPort(block) || block.hasVisibleName();
        return new LabelLayoutData(text, visible, font, position, blockLayoutData.getForegroundColor(), blockLayoutData.getOpacity());
    }

    private static Point calculateBlockLabelPosition(BlockLayoutData blockLayoutData, Rectangle textBounds, boolean alternatePlacement) {
        double yPosition;
        double xPosition;
        if (blockLayoutData.getOrientation() == EOrientation.LEFT || blockLayoutData.getOrientation() == EOrientation.RIGHT) {
            xPosition = blockLayoutData.getPosition().getCenterX() - (double)textBounds.width / 2.0;
            yPosition = alternatePlacement ? blockLayoutData.getPosition().getMinY() - (double)textBounds.height - 4.0 : blockLayoutData.getPosition().getMaxY() + 4.0;
        } else {
            yPosition = blockLayoutData.getPosition().getCenterY() - (double)textBounds.height / 2.0;
            xPosition = alternatePlacement ? blockLayoutData.getPosition().getMinX() - (double)textBounds.width - 4.0 : blockLayoutData.getPosition().getMaxX() + 4.0;
        }
        return new Point((int)xPosition, (int)yPosition);
    }

    public static LabelLayoutData extractBlockInnerLabelData(SimulinkBlock block, BlockLayoutData blockLayoutData) {
        if (block.getParameter("MaskDisplayString") != null) {
            return SimulinkElementLayoutUtils.obtainBlockInnerLabelDataFromDisplayString(block, blockLayoutData);
        }
        MaskObjectParameter maskObjectParameter = MaskObjectParameter.extractFromBlock(block);
        if (maskObjectParameter == null || StringUtils.isEmpty((String)maskObjectParameter.getLabelText())) {
            return null;
        }
        String text = maskObjectParameter.getLabelText();
        FontData font = LayoutHandlerBase.extractFontData(block);
        Rectangle bounds = LayoutHandlerBase.determineTextBounds(text, font.getAwtFont());
        Rectangle blockPosition = blockLayoutData.getPosition();
        Point position = new Point(blockPosition.x + (blockPosition.width - bounds.width) / 2, blockPosition.y + (blockPosition.height - bounds.height) / 2);
        return new LabelLayoutData(text, true, font, position, maskObjectParameter.getLabelColor(), blockLayoutData.getOpacity());
    }

    private static LabelLayoutData obtainBlockInnerLabelDataFromDisplayString(SimulinkBlock block, BlockLayoutData blockLayoutData) {
        String text = block.getParameter("MaskDisplayString");
        text = text.replace("\\\\n", "\n");
        text = text.replace("\\n", "\n");
        FontData font = LayoutHandlerBase.extractFontData(block);
        Rectangle bounds = LayoutHandlerBase.determineTextBounds(text, font.getAwtFont());
        Rectangle blockPosition = blockLayoutData.getPosition();
        Point position = new Point(blockPosition.x + (blockPosition.width - bounds.width) / 2, blockPosition.y + (blockPosition.height - bounds.height) / 2);
        return new LabelLayoutData(text, true, font, position, Color.BLACK, blockLayoutData.getOpacity());
    }

    public static LabelLayoutData extractBlockSubLabelData(SimulinkBlock block, String formatString, BlockLayoutData blockLayoutData) {
        LabelLayoutData mainLabel = SimulinkElementLayoutUtils.extractBlockLabelData(block, blockLayoutData);
        HashMap<String, String> placeholderSubstitutes = new HashMap<String, String>();
        String text = SimulinkUtils.replaceSimulinkLineBreaks(SimulinkElementLayoutUtils.resolveFormatPlaceholder(formatString, block, placeholderSubstitutes));
        Rectangle subLabelBounds = LayoutHandlerBase.determineTextBounds(text, mainLabel.getFont().getAwtFont());
        if (!mainLabel.isVisible()) {
            boolean alternatePlacement = "alternate".equals(block.getParameter("NamePlacement"));
            Point position = SimulinkElementLayoutUtils.calculateBlockLabelPosition(blockLayoutData, subLabelBounds, alternatePlacement);
            return new LabelLayoutData(text, true, mainLabel.getFont(), position, Color.GRAY, blockLayoutData.getOpacity(), placeholderSubstitutes);
        }
        Rectangle mainLabelBounds = LayoutHandlerBase.determineTextBounds(mainLabel.getText(), mainLabel.getFont().getAwtFont());
        mainLabelBounds.setLocation(mainLabel.getPosition());
        int x = (int)mainLabelBounds.getCenterX() - subLabelBounds.width / 2;
        int y = (int)mainLabelBounds.getMaxY() + 4;
        if (mainLabel.getPosition().y < blockLayoutData.getPosition().y) {
            y = (int)mainLabelBounds.getMinY() - 4 - subLabelBounds.height;
        }
        if (placeholderSubstitutes.isEmpty()) {
            placeholderSubstitutes = null;
        }
        return new LabelLayoutData(text, true, mainLabel.getFont(), new Point(x, y), Color.GRAY, blockLayoutData.getOpacity(), placeholderSubstitutes);
    }

    private static String resolveFormatPlaceholder(String formatString, SimulinkBlock block, Map<String, String> placeholderSubstitutes) {
        Matcher matcher = FORMAT_STRING_PLACEHOLDER_PATTERN.matcher(formatString);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String placeholder = matcher.group(1);
            String replacement = SimulinkUtils.replaceSimulinkLineBreaks(SimulinkElementLayoutUtils.findFormatPlaceholderReplacement(placeholder, block));
            placeholderSubstitutes.put(placeholder, replacement);
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String findFormatPlaceholderReplacement(String placeholderName, SimulinkBlock block) {
        Stack<SimulinkObject> stack = new Stack<SimulinkObject>();
        stack.addAll((Collection<SimulinkObject>)block.getObjects());
        while (!stack.isEmpty()) {
            SimulinkObject object = (SimulinkObject)stack.pop();
            if (placeholderName.equals(object.getName()) && object.getParameter("Value") != null) {
                return object.getParameter("Value");
            }
            stack.addAll((Collection<SimulinkObject>)object.getObjects());
        }
        String value = SimulinkElementLayoutUtils.getMaskVariableToValueMap(block).get(placeholderName);
        if (value != null) {
            return value;
        }
        if (block.getParameterIgnoreCase(placeholderName) != null) {
            return block.getParameterIgnoreCase(placeholderName);
        }
        if (block.getDefaultParameter(placeholderName) != null) {
            return block.getDefaultParameter(placeholderName);
        }
        if ("X0".equalsIgnoreCase(placeholderName)) {
            return SimulinkElementLayoutUtils.findFormatPlaceholderReplacement("InitialCondition", block);
        }
        return "%<" + placeholderName + ">";
    }

    private static Map<String, String> getMaskVariableToValueMap(SimulinkBlock block) {
        String valueString = block.getParameter("MaskValueString");
        String maskVariables = block.getParameter("MaskVariables");
        if (valueString == null || maskVariables == null) {
            return Collections.emptyMap();
        }
        String[] values = valueString.split("[|]");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : maskVariables.split(";")) {
            Matcher matcher = MASK_VARIABLE_PART_PATTERN.matcher(part);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            int index = Integer.parseInt(matcher.group(2)) - 1;
            if (index < 0 || index >= values.length) continue;
            result.put(name, values[index]);
        }
        return result;
    }
}

