/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ResolvedIdUtils;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclBase;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTarget;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

public class StateflowResolvedIdUtils {
    protected ResolvedIdUtils resolvedIdUtils = new ResolvedIdUtils();

    public String getResolvedId(StateflowElementBase<?> element) {
        if (element instanceof StateflowChart) {
            return this.getResolvedIdForStateflowChart((StateflowChart)element);
        }
        if (element instanceof StateflowNodeBase) {
            return this.getResolvedIdForStateflowNodeBase((StateflowNodeBase)element);
        }
        if (element instanceof StateflowMachine) {
            StateflowMachine machine = (StateflowMachine)element;
            return this.resolvedIdUtils.getResolvedId(machine.getModel());
        }
        if (element instanceof StateflowDeclBase || element instanceof StateflowTarget) {
            return null;
        }
        throw new IllegalArgumentException("unknown subclass of " + StateflowElementBase.class.getSimpleName() + ": " + element.getClass().getSimpleName());
    }

    private @NonNull String getResolvedIdForStateflowNodeBase(StateflowNodeBase node) {
        String resolvedLabel = SimulinkUtils.escapeSlashes(this.getResolvedStateflowLabel(node));
        if (node instanceof StateflowState && (((StateflowState)node).isMatlabFunction() || ((StateflowState)node).isFunctionState())) {
            String functionName = StateflowState.extractNameFromFunctionSignature(((StateflowState)node).getLabel());
            if (!resolvedLabel.equals("?") && !resolvedLabel.isEmpty()) {
                resolvedLabel = functionName;
            }
        }
        if (node instanceof StateflowState && (((StateflowState)node).isSimulinkFunction() || ((StateflowState)node).isActionSubsystemState())) {
            return this.getResolvedIdForStateflowChart(StateflowUtils.skipSubviewerParentCharts(node.getParentChart())) + "/" + resolvedLabel;
        }
        if (node.getParent() instanceof StateflowState) {
            return this.getResolvedIdForStateflowNodeBase((StateflowState)node.getParent()) + "/" + resolvedLabel;
        }
        StateflowChart parentChart = node.getParentChart();
        if (parentChart == null) {
            return resolvedLabel;
        }
        return this.getResolvedIdForStateflowChart(parentChart) + "/" + resolvedLabel;
    }

    private @Nullable String getResolvedIdForStateflowChart(StateflowChart chart) {
        if (!chart.isSubviewer()) {
            return this.resolvedIdUtils.getResolvedId(chart.getStateflowBlock());
        }
        IStateflowChartContainer parent = (IStateflowChartContainer)chart.getParent();
        if (!(parent instanceof StateflowState)) {
            return chart.getName();
        }
        if (((StateflowState)parent).isFunctionState()) {
            StateflowChart parentChart = StateflowUtils.skipSubviewerParentCharts(chart);
            return this.getResolvedIdForStateflowChart(parentChart) + "/" + StateflowUtils.extractIdFromStateflowId(chart.getStateflowId());
        }
        return this.getResolvedIdForStateflowNodeBase((StateflowState)chart.getParent());
    }

    public List<String> getSplitResolvedIdWithResolvedLabels(StateflowElementBase<?> element) {
        if (element instanceof StateflowChart) {
            return this.getSplitResolvedIdWithResolvedLabelsForStateflowChart((StateflowChart)element);
        }
        if (element instanceof StateflowMachine) {
            return this.resolvedIdUtils.getSplitResolvedIdWithResolvedLabels(((StateflowMachine)element).getModel());
        }
        if (element instanceof StateflowNodeBase) {
            return this.getSplitResolvedIdWithResolvedLabelsForStateflowNodeBase((StateflowNodeBase)element);
        }
        throw new IllegalArgumentException("unknown subclass of " + StateflowElementBase.class.getSimpleName() + ": " + element.getClass().getSimpleName());
    }

    private List<String> getSplitResolvedIdWithResolvedLabelsForStateflowChart(StateflowChart chart) {
        if (!chart.isSubviewer()) {
            return this.resolvedIdUtils.getSplitResolvedIdWithResolvedLabels(chart.getStateflowBlock());
        }
        IStateflowChartContainer parent = (IStateflowChartContainer)chart.getParent();
        if (parent instanceof StateflowState) {
            return this.getSplitResolvedIdWithResolvedLabels((StateflowState)parent);
        }
        return Collections.singletonList(chart.getName());
    }

    private @NonNull List<String> getSplitResolvedIdWithResolvedLabelsForStateflowNodeBase(StateflowNodeBase node) {
        String resolvedLabel = this.getResolvedStateflowLabel(node);
        IStateflowNodeContainer parent = (IStateflowNodeContainer)node.getParent();
        if (parent instanceof StateflowState) {
            ArrayList<String> splitIds = new ArrayList<String>(this.getSplitResolvedIdWithResolvedLabels((StateflowState)parent));
            splitIds.add(resolvedLabel);
            return splitIds;
        }
        StateflowChart parentChart = node.getParentChart();
        if (parentChart == null) {
            return new ArrayList<String>(Collections.singletonList(resolvedLabel));
        }
        ArrayList<String> splitIds = new ArrayList<String>(this.getSplitResolvedIdWithResolvedLabels(parentChart));
        splitIds.add(resolvedLabel);
        return splitIds;
    }

    private String getResolvedStateflowLabel(StateflowNodeBase node) {
        if (node instanceof StateflowJunction) {
            String label = node.getParameter("labelString");
            if (label != null) {
                return label;
            }
            return "Junction" + node.getStateflowId();
        }
        if (node instanceof StateflowState) {
            StateflowState state = (StateflowState)node;
            if (state.isSimulinkFunction() || state.isActionSubsystemState()) {
                return state.getSimulinkBlock().getName();
            }
            return StateflowUtils.getStateName(state);
        }
        throw new IllegalArgumentException("unknown subclass of " + StateflowNodeBase.class.getSimpleName() + ": " + node.getClass().getSimpleName());
    }

    public String getResolvedIdWithResolvedLabels(StateflowElementBase<?> element) {
        List<String> splitResolvedId = this.getSplitResolvedIdWithResolvedLabels(element);
        CCSMAssert.isNotEmpty(splitResolvedId, (String)"Split resolved ID list is empty.");
        return StringUtils.concat(splitResolvedId, (String)"/");
    }
}

