/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;

class TransitionCloneUtils {
    TransitionCloneUtils() {
    }

    public static void cloneTransitions(IStateflowNodeContainer<?> orig, IStateflowNodeContainer<?> clone) {
        ArrayList<StateflowTransition> transitions = new ArrayList<StateflowTransition>();
        TransitionCloneUtils.extractInTransitionsRecursive(orig, transitions);
        HashMap<String, StateflowNodeBase> idToNode = new HashMap<String, StateflowNodeBase>();
        TransitionCloneUtils.fillIdToNodeMap(clone, idToNode);
        if (orig instanceof StateflowNodeBase) {
            transitions.addAll((Collection<StateflowTransition>)((StateflowNodeBase)((Object)orig)).getInTransitions());
            idToNode.put(clone.getStateflowId(), (StateflowNodeBase)((Object)clone));
        }
        for (StateflowTransition transition : transitions) {
            TransitionCloneUtils.duplicateTransition(transition, orig, clone, idToNode);
        }
        if (orig instanceof StateflowChart) {
            for (StateflowTransition transition : ((StateflowChart)orig).getUnconnectedTransitions()) {
                StateflowTransition clonedTransition = new StateflowTransition(null, null);
                SimulinkUtils.copyParameters(transition, clonedTransition);
                ((StateflowChart)clone).addUnconnectedTransition(clonedTransition);
            }
        }
    }

    private static void duplicateTransition(StateflowTransition transition, IStateflowNodeContainer<?> orig, IStateflowNodeContainer<?> clone, Map<String, StateflowNodeBase> idToNode) {
        StateflowNodeBase dstNode = idToNode.get(transition.getDst().getStateflowId());
        if (dstNode == null) {
            return;
        }
        if (transition.getSrc() == null) {
            if (transition.getDst() == orig) {
                SimulinkUtils.copyParameters(transition, new StateflowTransition(null, dstNode));
            }
            return;
        }
        StateflowNodeBase srcNode = idToNode.get(transition.getSrc().getStateflowId());
        if (srcNode == null) {
            return;
        }
        if (TransitionCloneUtils.getLowestCommonAncestor(srcNode, dstNode) == clone) {
            SimulinkUtils.copyParameters(transition, new StateflowTransition(srcNode, dstNode));
        }
    }

    private static void extractInTransitionsRecursive(IStateflowNodeContainer<?> container, List<StateflowTransition> transitions) {
        for (StateflowNodeBase node : container.getNodes()) {
            transitions.addAll((Collection<StateflowTransition>)node.getInTransitions());
            if (!(node instanceof IStateflowNodeContainer)) continue;
            TransitionCloneUtils.extractInTransitionsRecursive((IStateflowNodeContainer)((Object)node), transitions);
        }
        if (container instanceof StateflowState && ((StateflowState)container).isSubChart()) {
            TransitionCloneUtils.extractInTransitionsRecursive(((StateflowState)container).getSubViewer(), transitions);
        }
    }

    private static void fillIdToNodeMap(IStateflowNodeContainer<?> container, Map<String, StateflowNodeBase> idToNode) {
        for (StateflowNodeBase node : container.getNodes()) {
            idToNode.put(node.getStateflowId(), node);
            if (!(node instanceof IStateflowNodeContainer)) continue;
            TransitionCloneUtils.fillIdToNodeMap((IStateflowNodeContainer)((Object)node), idToNode);
        }
        if (container instanceof StateflowState && ((StateflowState)container).isSubChart()) {
            TransitionCloneUtils.fillIdToNodeMap(((StateflowState)container).getSubViewer(), idToNode);
        }
    }

    private static IStateflowElement<?> getLowestCommonAncestor(IStateflowElement<?> elem1, IStateflowElement<?> elem2) {
        IdentityHashSet ancestors1 = new IdentityHashSet();
        while (elem1 != null) {
            ancestors1.add(elem1);
            elem1 = elem1.getParent();
        }
        while (elem2 != null) {
            if (ancestors1.contains(elem2)) {
                return elem2;
            }
            elem2 = elem2.getParent();
        }
        return null;
    }
}

