/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkConstants;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.types.ENumericDataType;
import org.conqat.lib.simulink.types.NarrowestContainingTypeMatrix;

public class SimulinkDataTypeUtils {
    private static final Set<String> TYPES_WITHOUT_BACKPROPAGATION = CollectionUtils.asHashSet((Object[])new String[]{"SubSystem", "DataTypeConversion", "S-Function", "BusSelector", "BusCreator", "Terminator", "RelationalOperator", "PreLookup"});
    private static final Set<String> SOURCE_TYPES_WITH_BACKPROPAGATION = CollectionUtils.asHashSet((Object[])new String[]{"Difference", "First Order Transfer Fcn", "Transfer Fcn Real Zero", "Lead or Lag Compensator", "Discrete Transfer Function with Initial Outputs", "Discrete Transfer Function with Initial States", "Discrete Derivative", "Algebraic Constraint", "Slider Gain"});
    private static final Set<String> FLOATING_POINT_DATA_TYPES = CollectionUtils.asHashSet((Object[])new String[]{"double", "single", "half"});
    private static final Set<String> NUMERIC_DATA_TYPES = CollectionUtils.unionSet((Collection)CollectionUtils.asHashSet((Object[])new String[]{"int64", "int32", "int16", "int8", "uint64", "uint32", "uint16", "uint8"}), (Collection[])new Collection[]{FLOATING_POINT_DATA_TYPES});
    private static final Set<String> BUILT_IN_DATA_TYPES = CollectionUtils.unionSet(NUMERIC_DATA_TYPES, (Collection[])new Collection[]{CollectionUtils.asHashSet((Object[])new String[]{"boolean", "string"})});
    private static final Set<String> UNSIGNED_INT_DATA_TYPES = CollectionUtils.asHashSet((Object[])new String[]{"uint8", "uint16", "uint32", "uint64"});
    private static final Set<String> INPUT_TYPE_INHERITING_BLOCKS = CollectionUtils.asHashSet((Object[])new String[]{"BusSelector", "Concatenate", "Demux", "Selector"});
    private static final Set<String> INTERNAL_RULE_INHERITING_BLOCKS = CollectionUtils.asHashSet((Object[])new String[]{"Sum", "Product"});

    public static boolean isBuiltInDataType(String dataType) {
        return BUILT_IN_DATA_TYPES.contains(dataType);
    }

    public static boolean isNumericDataType(String dataType) {
        return NUMERIC_DATA_TYPES.contains(dataType);
    }

    public static boolean isFloatingPointDataType(String dataType) {
        return FLOATING_POINT_DATA_TYPES.contains(dataType);
    }

    public static boolean isUnsignedIntDataType(String dataType) {
        return UNSIGNED_INT_DATA_TYPES.contains(dataType);
    }

    public static boolean isEnumDataType(String dataType) {
        return dataType != null && (dataType.startsWith("Enum:") || dataType.startsWith("?"));
    }

    public static boolean isBusDataType(String dataType) {
        return dataType != null && dataType.startsWith("Bus");
    }

    public static String determineDataTypeOfValue(@Nullable String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "Unknown";
        }
        if ("true".equals(value) || "false".equals(value)) {
            return "boolean";
        }
        if (Pattern.compile("\\p{Nd}").matcher(value).find()) {
            return "double";
        }
        return "Unknown";
    }

    public static Optional<String> selectFloatingPointDataTypeWithLargestRange(Set<String> dataTypes) {
        if (dataTypes.contains("double")) {
            return Optional.of("double");
        }
        if (dataTypes.contains("single")) {
            return Optional.of("single");
        }
        if (dataTypes.contains("half")) {
            return Optional.of("half");
        }
        return Optional.empty();
    }

    public static ENumericDataType getContainingDataType(Set<ENumericDataType> dataTypes) {
        if (dataTypes.size() == 1 && dataTypes.contains((Object)ENumericDataType.BOOLEAN)) {
            return ENumericDataType.BOOLEAN;
        }
        if (dataTypes.isEmpty()) {
            return ENumericDataType.DOUBLE;
        }
        ENumericDataType typeWithHighestMaxValue = dataTypes.stream().max(Comparator.comparing(ENumericDataType::max)).get();
        ENumericDataType typeWithLowestMinValue = dataTypes.stream().min(Comparator.comparing(ENumericDataType::min)).get();
        if (typeWithLowestMinValue == ENumericDataType.BOOLEAN) {
            typeWithLowestMinValue = ENumericDataType.UINT8;
        }
        return NarrowestContainingTypeMatrix.getNarrowestContainingType(typeWithLowestMinValue, typeWithHighestMaxValue);
    }

    public static String selectDataTypeWithLargestRange(Set<String> dataTypes) {
        Optional<String> optionalFloatingDataType = SimulinkDataTypeUtils.selectFloatingPointDataTypeWithLargestRange(dataTypes);
        if (optionalFloatingDataType.isPresent()) {
            return optionalFloatingDataType.get();
        }
        Set<String> nonNumericDataTypes = dataTypes.stream().filter(type -> !EnumUtils.isValidEnum(ENumericDataType.class, (String)type.toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
        if (!nonNumericDataTypes.isEmpty()) {
            return SimulinkDataTypeUtils.selectDataTypeWithLargestRangeForNonNumerics(nonNumericDataTypes);
        }
        ENumericDataType enums = dataTypes.stream().filter(Objects::nonNull).map(s -> ENumericDataType.valueOf(s.toUpperCase(Locale.ROOT))).max(Comparator.comparing(ENumericDataType::max)).orElse(ENumericDataType.DOUBLE);
        if (enums == ENumericDataType.BOOLEAN && dataTypes.contains("uint8")) {
            enums = ENumericDataType.UINT8;
        }
        return enums.name().toLowerCase(Locale.ROOT);
    }

    private static String selectDataTypeWithLargestRangeForNonNumerics(Set<String> nonNumerics) {
        if (nonNumerics.isEmpty()) {
            return "Unknown";
        }
        Set busDataTypes = nonNumerics.stream().filter(SimulinkDataTypeUtils::isBusDataType).collect(Collectors.toSet());
        if (!busDataTypes.isEmpty()) {
            return (String)busDataTypes.stream().min(String::compareTo).get();
        }
        Set nonUnknownDataTypes = nonNumerics.stream().filter(type -> !"Unknown".equals(type)).collect(Collectors.toSet());
        if (!nonUnknownDataTypes.isEmpty()) {
            return (String)nonUnknownDataTypes.stream().min(String::compareTo).get();
        }
        return "Unknown";
    }

    public static String getDataTypeWithLargerRange(String dataType) {
        if ("fixdt".equals(dataType)) {
            return "fixdt";
        }
        if ("enum".equals(dataType)) {
            return "enum";
        }
        if ("string".equals(dataType)) {
            return "string";
        }
        switch (dataType) {
            case "uint32": {
                return "uint64";
            }
            case "int32": {
                return "int64";
            }
            case "uint16": {
                return "uint32";
            }
            case "int16": {
                return "int32";
            }
            case "uint8": {
                return "uint16";
            }
            case "int8": {
                return "int16";
            }
            case "boolean": {
                return "uint8";
            }
        }
        return "double";
    }

    public static int compareRangeOfNumericDataTypes(String dataType1, String dataType2) {
        String enumDataType1 = dataType1.toUpperCase(Locale.ROOT);
        String enumDataType2 = dataType2.toUpperCase(Locale.ROOT);
        CCSMAssert.isTrue((boolean)EnumUtils.isValidEnum(ENumericDataType.class, (String)enumDataType1), (String)(enumDataType1 + " is no valid enum in " + ENumericDataType.class.getSimpleName()));
        CCSMAssert.isTrue((boolean)EnumUtils.isValidEnum(ENumericDataType.class, (String)enumDataType2), (String)(enumDataType2 + " is no valid enum in " + ENumericDataType.class.getSimpleName()));
        ENumericDataType e1 = ENumericDataType.valueOf(enumDataType1);
        ENumericDataType e2 = ENumericDataType.valueOf(enumDataType2);
        return e1.max().compareTo(e2.max());
    }

    public static boolean containsFixedPointDataTypes(Set<String> dataTypes) {
        return dataTypes.contains("fixdt");
    }

    public static boolean rangesAreCompatible(Set<ENumericDataType> dataTypes) {
        return dataTypes.contains((Object)SimulinkDataTypeUtils.getContainingDataType(dataTypes));
    }

    private static ENumericDataType getSmallestDataType(Set<ENumericDataType> dataTypes) {
        return dataTypes.stream().min(Comparator.comparing(ENumericDataType::max)).orElse(ENumericDataType.DOUBLE);
    }

    public static Set<String> getInputDataPortNumbers(SimulinkBlock block) {
        return block.getInPorts().stream().map(SimulinkPortBase::getIndex).filter(inport -> !inport.equals(SimulinkDataTypeUtils.getInputControlPortNumber(block))).collect(Collectors.toSet());
    }

    public static String getInputControlPortNumber(SimulinkBlock block) {
        switch (block.getType()) {
            case "Switch": {
                return "2";
            }
            case "MultiPortSwitch": {
                return "1";
            }
        }
        return null;
    }

    public static boolean isPortWithBackPropagation(@Nullable SimulinkInPort inPort) {
        if (inPort == null) {
            return false;
        }
        SimulinkBlock block = inPort.getBlock();
        String type = block.getType();
        if (type == null) {
            return false;
        }
        if (TYPES_WITHOUT_BACKPROPAGATION.contains(type)) {
            return false;
        }
        if ("Reference".equals(type) && !SOURCE_TYPES_WITH_BACKPROPAGATION.contains(block.getSourceType())) {
            return false;
        }
        return !inPort.getIndex().equals(SimulinkDataTypeUtils.getInputControlPortNumber(block));
    }

    public static String getRealDataTypeOfFixedDataType(String fixedDataType, boolean keepOriginalFixedPointFunction) {
        String numericType;
        if (!fixedDataType.startsWith("fixdt")) {
            return fixedDataType;
        }
        String[] parts = StringUtils.split((String)fixedDataType, (String)"'");
        if (parts.length > 1 && EnumUtils.isValidEnum(ENumericDataType.class, (String)(numericType = parts[1]).toUpperCase(Locale.ROOT))) {
            return numericType;
        }
        if (keepOriginalFixedPointFunction) {
            return fixedDataType;
        }
        return "fixdt";
    }

    public static @Nullable String normalizeDataType(@Nullable String dataTypeFromSimulinkModel) {
        if (dataTypeFromSimulinkModel == null) {
            return null;
        }
        if ("logical".equalsIgnoreCase(dataTypeFromSimulinkModel)) {
            return "boolean";
        }
        return dataTypeFromSimulinkModel;
    }

    public static String getUnresolvedOutputDataType(SimulinkBlock block) {
        String dataType = block.isOfType("LookupNDDirect") ? block.getParameter("TableDataTypeStr") : (block.isOfSourceType("PID 1dof") || block.isOfSourceType("PID 2dof") ? block.getParameter("SumOutDataTypeStr") : (block.isOfType("PreLookup") ? block.getParameter("FractionDataTypeStr") : (block.isOfType("ForIterator") ? block.getParameter("IterationVariableDataType") : block.getParameter("OutDataTypeStr"))));
        return SimulinkDataTypeUtils.normalizeDataType(dataType);
    }

    public static String sanitizeTypeFromSimulinkModel(String rawTypeName, boolean returnRawTypeIfUnknown) {
        for (String typeName : SimulinkConstants.DataType.STANDARD_TYPES_NAMES) {
            if (!typeName.equalsIgnoreCase(rawTypeName)) continue;
            return typeName;
        }
        if (rawTypeName.startsWith("Fixed-point: ")) {
            return "fixdt";
        }
        if (rawTypeName.startsWith("Bus: ")) {
            return "Bus";
        }
        if (returnRawTypeIfUnknown) {
            return rawTypeName;
        }
        return "Unknown";
    }

    public static boolean usesInheritAuto(SimulinkBlock block) {
        String datatype = SimulinkDataTypeUtils.getUnresolvedOutputDataType(block);
        return "Inherit: auto".equals(datatype);
    }

    public static boolean usesInternalRuleInheritance(SimulinkBlock block) {
        String datatype = SimulinkDataTypeUtils.getUnresolvedOutputDataType(block);
        return INTERNAL_RULE_INHERITING_BLOCKS.contains(block.getType()) && "Inherit: Inherit via internal rule".equals(datatype);
    }

    public static boolean hasAutoOrImplicitTypeInheritance(SimulinkBlock block) {
        String datatype = SimulinkDataTypeUtils.getUnresolvedOutputDataType(block);
        boolean isInputInheritingBlockWithoutDataType = INPUT_TYPE_INHERITING_BLOCKS.contains(block.getType()) && datatype == null;
        return SimulinkDataTypeUtils.usesInheritAuto(block) || SimulinkDataTypeUtils.usesInternalRuleInheritance(block) || isInputInheritingBlockWithoutDataType;
    }

    public static Set<ENumericDataType> createEIntegerDataTypeSet(Set<String> dataTypes) {
        Set validEnumNames = Arrays.stream(ENumericDataType.values()).map(Enum::name).collect(Collectors.toSet());
        return dataTypes.stream().filter(type -> type != null && !type.equals("Unknown") && !type.equals("NOT_CONNECTED")).filter(s -> validEnumNames.contains(s.toUpperCase(Locale.ROOT))).map(s -> ENumericDataType.valueOf(s.toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
    }

    private static Optional<ENumericDataType> selectNextLargerIntTypeForProductBlock(ENumericDataType containingDataType) {
        return switch (containingDataType) {
            case ENumericDataType.INT8 -> Optional.of(ENumericDataType.INT16);
            case ENumericDataType.UINT8 -> Optional.of(ENumericDataType.UINT16);
            case ENumericDataType.INT16 -> Optional.of(ENumericDataType.INT32);
            case ENumericDataType.UINT16 -> Optional.of(ENumericDataType.UINT32);
            case ENumericDataType.INT32, ENumericDataType.INT64 -> Optional.of(ENumericDataType.INT64);
            case ENumericDataType.UINT32, ENumericDataType.UINT64 -> Optional.of(ENumericDataType.UINT64);
            default -> Optional.empty();
        };
    }

    public static String determineProductBlockOutputType(Set<String> inputDataTypes) {
        Optional<ENumericDataType> nextLargerType;
        Set<ENumericDataType> integerDataTypes = SimulinkDataTypeUtils.createEIntegerDataTypeSet(inputDataTypes);
        ENumericDataType smallestDataType = SimulinkDataTypeUtils.getSmallestDataType(integerDataTypes);
        ENumericDataType containingDataType = SimulinkDataTypeUtils.getContainingDataType(integerDataTypes);
        if (integerDataTypes.size() > 1 && integerDataTypes.contains((Object)containingDataType) && EnumSet.of(ENumericDataType.INT32, ENumericDataType.UINT32).contains((Object)containingDataType) && EnumSet.of(ENumericDataType.INT8, new ENumericDataType[]{ENumericDataType.UINT8, ENumericDataType.INT16, ENumericDataType.UINT16, ENumericDataType.INT32, ENumericDataType.UINT32}).containsAll(integerDataTypes)) {
            return "fixdt";
        }
        if (integerDataTypes.contains((Object)containingDataType) && (nextLargerType = SimulinkDataTypeUtils.selectNextLargerIntTypeForProductBlock(containingDataType)).isPresent()) {
            containingDataType = nextLargerType.get();
        }
        if (containingDataType.max().compareTo(ENumericDataType.UINT32.max()) > 0) {
            if (smallestDataType == ENumericDataType.UINT8 || smallestDataType == ENumericDataType.INT32) {
                return containingDataType.name().toLowerCase();
            }
            return "fixdt";
        }
        return containingDataType.name().toLowerCase();
    }

    public static String determineSumBlockOutputType(Set<String> inputDataTypes) {
        Set<ENumericDataType> integerDataTypes = SimulinkDataTypeUtils.createEIntegerDataTypeSet(inputDataTypes);
        if (SimulinkDataTypeUtils.rangesAreCompatible(integerDataTypes)) {
            String outputDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(inputDataTypes);
            if ("boolean".equals(outputDataType)) {
                return "uint8";
            }
            return outputDataType;
        }
        return "fixdt";
    }
}

