/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.function.FunctionWithException;

public class SimulinkJsonUtils {
    private static final JsonFactory JSON_FACTORY = JsonFactory.builder().enable(JsonReadFeature.ALLOW_TRAILING_COMMA).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).build();
    private static final ObjectMapper OBJECT_MAPPER = SimulinkJsonUtils.defaultObjectMapperBuilder().build();
    private static final ObjectMapper CANONICAL_OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)JSON_FACTORY).visibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).serializationInclusion(JsonInclude.Include.NON_NULL)).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).disable(new MapperFeature[]{MapperFeature.SORT_CREATOR_PROPERTIES_FIRST})).enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS})).addModule((Module)new SimpleModule())).build();

    private static JsonMapper.Builder defaultObjectMapperBuilder() {
        JsonFactory jsonFactory = JsonFactory.builder().enable(JsonReadFeature.ALLOW_TRAILING_COMMA).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).build();
        JsonMapper.Builder builder = JsonMapper.builder((JsonFactory)jsonFactory);
        return SimulinkJsonUtils.configureDefaultSettings(builder);
    }

    public static <M extends ObjectMapper, B extends MapperBuilder<M, B>> B configureDefaultSettings(B builder) {
        return (B)builder.addModule((Module)new GuavaModule()).addModule((Module)new JavaTimeModule()).visibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).serializationInclusion(JsonInclude.Include.NON_NULL).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public static JsonNode parseJson(String json) throws JsonProcessingException {
        return CANONICAL_OBJECT_MAPPER.readTree(json);
    }

    public static <T> T deserializeFromJson(String json, Class<T> expectedClass) throws ConQATException {
        return SimulinkJsonUtils.deserializeFromJson(json, SimulinkJsonUtils.getJavaType(expectedClass));
    }

    public static <T> T deserializeFromJson(String json, JavaType expectedType) throws ConQATException {
        return SimulinkJsonUtils.safeConvert(objectMapper -> objectMapper.readValue(json, expectedType));
    }

    private static <T> T safeConvert(FunctionWithException<ObjectMapper, T, IOException> convertAction) throws ConQATException {
        return SimulinkJsonUtils.safeConvert(convertAction, OBJECT_MAPPER);
    }

    private static <T> T safeConvert(FunctionWithException<ObjectMapper, T, IOException> convertAction, ObjectMapper objectMapper) throws ConQATException {
        try {
            return (T)convertAction.apply((Object)objectMapper);
        }
        catch (JsonProcessingException e) {
            throw new ConQATException("Input was invalid JSON.", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConQATException("Trouble during JSON processing: " + t.getMessage(), t);
        }
    }

    private static <T> JavaType getJavaType(Class<T> resultClass) {
        return OBJECT_MAPPER.constructType(resultClass);
    }
}

