/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import org.jetbrains.annotations.NotNull;

final class EscapingByteIterable
extends ByteIterableBase {
    static final byte ESCAPING_BYTE = 1;
    @NotNull
    private final ByteIterable origin;

    EscapingByteIterable(@NotNull ByteIterable origin) {
        this.origin = origin;
    }

    protected ByteIterator getIterator() {
        return new ByteIterator(){
            private final ByteIterator originIt;
            private boolean hasEscaped;
            private byte escaped;
            {
                this.originIt = EscapingByteIterable.this.origin.iterator();
                this.hasEscaped = false;
                this.escaped = 0;
            }

            public boolean hasNext() {
                return this.hasEscaped || this.originIt.hasNext();
            }

            public byte next() {
                if (this.hasEscaped) {
                    this.hasEscaped = false;
                    return this.escaped;
                }
                byte nextByte = this.originIt.next();
                if (nextByte == 0 || nextByte == 1) {
                    this.hasEscaped = true;
                    this.escaped = (byte)(nextByte + 1);
                    return 1;
                }
                return nextByte;
            }

            public long skip(long bytes) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

