/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.CodeScopeValidationViolation;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ProjectConfigurationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private @Nullable Collection<CodeScopeValidationViolation> codeScopeViolations;
    private final @Nullable Integer connectorIndex;

    public ProjectConfigurationException(String message) {
        super(message);
        this.connectorIndex = null;
    }

    public ProjectConfigurationException(String message, @NonNull Collection<CodeScopeValidationViolation> codeScopeViolations) {
        super(message);
        this.codeScopeViolations = codeScopeViolations;
        this.connectorIndex = null;
    }

    public ProjectConfigurationException(Throwable cause) {
        super(cause);
        this.connectorIndex = null;
    }

    public ProjectConfigurationException(String message, Throwable cause) {
        super(message, cause);
        this.connectorIndex = null;
    }

    public ProjectConfigurationException(ConnectorValidationException e, @Nullable Integer connectorIndex) {
        super(e.getMessage(), e);
        this.connectorIndex = connectorIndex;
    }

    public @Nullable Integer getConnectorIndex() {
        return this.connectorIndex;
    }

    public @Nullable Collection<CodeScopeValidationViolation> getCodeScopeViolations() {
        return this.codeScopeViolations;
    }

    public @Nullable String getCodeScopeViolationsMessage() {
        if (CollectionUtils.isNullOrEmpty(this.codeScopeViolations)) {
            return null;
        }
        return this.codeScopeViolations.stream().map(CodeScopeValidationViolation::toHumanReadable).collect(Collectors.joining("\n"));
    }
}

