/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AnalysisProfileEditVersionComparisonUtils {
    private static final float RENAME_GROUP_MATCHING_THRESHOLD = 0.8f;

    static String[] getStringChanges(String oldString, String newString) {
        int endIndex = StringUtils.indexOfDifference((CharSequence)oldString, (CharSequence)newString);
        String[] stringDiff = new String[]{endIndex > 0 ? oldString.substring(0, endIndex) : "", StringUtils.difference((String)newString, (String)oldString), StringUtils.difference((String)oldString, (String)newString)};
        return stringDiff;
    }

    static Optional<QualityIndicator> oldMatchedRename(QualityIndicator unmatchedNew, Set<QualityIndicator> oldUnmatchedIndicators) {
        for (QualityIndicator oldIndicator : oldUnmatchedIndicators) {
            Set newGroups = unmatchedNew.getGroups().stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.toSet());
            Set oldGroups = oldIndicator.getGroups().stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.toSet());
            int countMatchingNewGroups = 0;
            for (String newGroup : newGroups) {
                if (!oldGroups.contains(newGroup)) continue;
                ++countMatchingNewGroups;
            }
            int countMatchingOldGroups = 0;
            for (String oldGroup : oldGroups) {
                if (!newGroups.contains(oldGroup)) continue;
                ++countMatchingOldGroups;
            }
            if (!((double)countMatchingNewGroups / (double)newGroups.size() >= (double)0.8f) && !((double)countMatchingOldGroups / (double)oldGroups.size() >= (double)0.8f)) continue;
            return Optional.of(oldIndicator);
        }
        return Optional.empty();
    }

    private static boolean equalStringSets(Map<String, String> optionsOld, String optionName, String newOptionValue) {
        if (newOptionValue.contains(",")) {
            Set<String> oldListParts = AnalysisProfileEditVersionComparisonUtils.splitStringListIntoParts(optionsOld.get(optionName));
            Set<String> newListParts = AnalysisProfileEditVersionComparisonUtils.splitStringListIntoParts(newOptionValue);
            return oldListParts.size() == newListParts.size() && oldListParts.containsAll(newListParts) && newListParts.containsAll(oldListParts);
        }
        return false;
    }

    private static Set<String> splitStringListIntoParts(String text) {
        return Arrays.stream(text.replaceAll("\\s+", "").split(",")).map(s -> {
            if (s.contains("\":\"")) {
                if (s.charAt(s.length() - 1) == '\"') {
                    return s.replace("\":\"", "\":").substring(0, s.length() - 2);
                }
                if (s.charAt(s.length() - 2) == '\"' && s.charAt(s.length() - 1) == '}') {
                    return s.replace("\":\"", "\":").substring(0, s.length() - 3) + "}";
                }
            }
            return s;
        }).collect(Collectors.toSet());
    }

    public static String transformCheckIdToReadableNames(String checkId, AnalysisGroupDescriptor analysisGroup) {
        ConfigurationItemBase configurationItem = analysisGroup.getConfigurationItem(checkId);
        if (configurationItem == null) {
            return checkId;
        }
        if (!(configurationItem instanceof FindingDescriptor)) {
            return checkId;
        }
        return ((FindingDescriptor)configurationItem).getReadableName();
    }

    static List<String[]> getDifferenceInOptions(Map<String, String> optionsOld, Map<String, String> optionsNew, Set<String> addedOptions) {
        ArrayList<String[]> changesOtherOptions = new ArrayList<String[]>();
        if (optionsNew == null) {
            return changesOtherOptions;
        }
        for (Map.Entry<String, String> entry : optionsNew.entrySet()) {
            String optionName = entry.getKey();
            String newOptionValue = entry.getValue();
            if (optionsOld == null || newOptionValue == null || addedOptions.contains(optionName)) continue;
            if (optionsOld.get(optionName) == null && !newOptionValue.equalsIgnoreCase("false") && !newOptionValue.equalsIgnoreCase("off")) {
                if (addedOptions.contains(optionName)) {
                    changesOtherOptions.add(new String[]{optionName, "", newOptionValue});
                    continue;
                }
                if ("true".equalsIgnoreCase(newOptionValue)) {
                    changesOtherOptions.add(new String[]{optionName, "false", newOptionValue});
                    continue;
                }
                changesOtherOptions.add(new String[]{optionName, "off", newOptionValue});
                continue;
            }
            if (optionsOld.get(optionName) == null || newOptionValue.replaceAll("\\s+", "").equalsIgnoreCase(optionsOld.get(optionName).replaceAll("\\s+", "")) || AnalysisProfileEditVersionComparisonUtils.equalStringSets(optionsOld, optionName, newOptionValue)) continue;
            changesOtherOptions.add(new String[]{optionName, optionsOld.get(optionName), newOptionValue});
        }
        return changesOtherOptions;
    }

    static <T extends Enum<T>> Set<T> getAdditionalEntries(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty()) {
            return new HashSet();
        }
        EnumSet<T> additionalEntries = EnumSet.copyOf(set1);
        additionalEntries.removeAll(set2);
        return additionalEntries;
    }
}

