/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import java.io.Serializable;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FindingDescriptor.class), @JsonSubTypes.Type(value=MetricDescriptor.class)})
public abstract class ConfigurationItemBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String NAME_PROPERTY = "name";
    protected static final String DESCRIPTION_PROPERTY = "description";
    private static final String VISIBILITY_PROPERTY = "visibility";
    private static final String CODE_SCOPE_AWARE_PROPERTY = "isCodeScopeAware";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="visibility")
    private final ConfigExposed.EConfigVisibility visibility;
    @JsonProperty(value="isCodeScopeAware")
    private boolean isCodeScopeAware = false;
    @JsonIgnore
    private ConfigurationBase configuration;

    protected ConfigurationItemBase(String name, String description, ConfigExposed.EConfigVisibility visibility) {
        this.name = name;
        this.description = description;
        this.visibility = visibility;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigExposed.EConfigVisibility getVisibility() {
        return this.visibility;
    }

    public abstract void setValue(String var1, CodeScopeName var2) throws ProjectConfigurationException;

    public abstract boolean requiredToolPresent(Set<EAnalysisTool> var1);

    protected void setConfiguration(ConfigurationBase configuration) {
        CCSMAssert.isTrue((this.configuration == null || this.configuration == configuration ? 1 : 0) != 0, (String)"May not set configuration multiple times with different configurations.");
        this.configuration = configuration;
    }

    public ConfigurationBase getConfiguration() {
        CCSMAssert.isTrue((this.configuration != null ? 1 : 0) != 0, (String)("Should never work with dangling configuration items:" + this.getName()));
        return this.configuration;
    }

    public abstract boolean isActive();

    public String toString() {
        return this.name;
    }

    public @NonNull String normalizeValue(@Nullable String value) throws ProjectConfigurationException {
        if (value == null) {
            return "";
        }
        return value;
    }

    public void declareCodeScopeAware() {
        this.isCodeScopeAware = true;
    }

    public boolean codeScopeAware() {
        return this.isCodeScopeAware;
    }
}

