/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CollectionOptionDescriptorBase<T extends Collection<String>>
extends ConfigOptionDescriptorBase {
    private static final long serialVersionUID = 1L;

    public CollectionOptionDescriptorBase(ConfigExposed annotation, Field field, String typeName) {
        super(annotation, field, typeName);
    }

    public CollectionOptionDescriptorBase(String name, String description, boolean multilineText, IConfigOptionDescriptorBehaviour behaviour) {
        super(name, description, multilineText, behaviour);
    }

    protected CollectionOptionDescriptorBase(String name, String description) {
        super(name, description);
    }

    @Override
    public void setValueAndDefaultValue(String optionValue, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        String valueAsString = this.getValueAsString((Collection)this.parseValue(optionValue));
        this.setValue(valueAsString, codeScopeName);
        this.defaultValue = valueAsString;
    }

    @Override
    public String retrieveValueAsString(CodeScopeName codeScopeName) {
        Object value = this.retrieveValue(codeScopeName);
        if (value == null) {
            return null;
        }
        return this.getValueAsString((Collection)value);
    }

    @Override
    public String getDefaultValueAsString() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.getValueAsString((Collection)this.defaultValue);
    }

    private String getValueAsString(T value) {
        return StringUtils.concatWithEscapeCharacter(new ArrayList(value), (Character)CollectionUtils.MULTI_VALUE_DELIMITER);
    }

    @Override
    protected Object parseValue(String optionValue) throws ProjectConfigurationException {
        try {
            List<String> results = CollectionOptionDescriptorBase.parseStringToListOfStrings(optionValue);
            return this.convertFromList(results);
        }
        catch (IllegalArgumentException e) {
            throw new ProjectConfigurationException(e.getMessage(), e);
        }
    }

    public static List<String> parseStringToListOfStrings(@Nullable String optionValue) {
        List results = StringUtils.splitWithEscapeCharacter((String)optionValue, (Character)Character.valueOf('\n'));
        results = CollectionUtils.parseMultiValueStringToList((List)results, (boolean)true);
        return results;
    }

    protected abstract T convertFromList(List<String> var1);
}

