/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.conqat.engine.index.shared.CodeScopeName;

public class NumberOptionDescriptor<T extends Number>
extends ConfigOptionDescriptorBase {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private final Function<String, T> mapper;

    public NumberOptionDescriptor(ConfigExposed annotation, Field field, Function<String, T> mapper) {
        super(annotation, field);
        this.mapper = mapper;
    }

    public NumberOptionDescriptor(String name, String description, IConfigOptionDescriptorBehaviour behaviour, Function<String, T> mapper) {
        super(name, description, false, behaviour);
        this.mapper = mapper;
    }

    @JsonCreator
    public NumberOptionDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description) {
        super(name, description);
        this.mapper = null;
    }

    @Override
    public void setValue(String optionValue, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        this.validateValue(optionValue);
        if (optionValue == null || optionValue.isEmpty()) {
            this.storeValue(this.retrieveDefaultValue(), codeScopeName);
        } else {
            this.storeValue(this.parseValue(optionValue), codeScopeName);
        }
    }

    protected T parseValue(String optionValue) throws ProjectConfigurationException {
        try {
            return (T)((Number)this.mapper.apply(optionValue));
        }
        catch (NumberFormatException e) {
            throw new ProjectConfigurationException("Invalid number for option " + this.getName() + ": " + optionValue, e);
        }
    }
}

