/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.crowd.CrowdProvider;
import com.teamscale.core.authenticate.github.GitHubProvider;
import com.teamscale.core.authenticate.ldap.LDAPProvider;
import com.teamscale.core.authenticate.saml.SamlAuthenticationProvider;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationProvider;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class AuthenticationToolUtils {
    public static final String SERVER_NAME_PARAMETER_NAME = "server-name";
    public static final String SERVER_TYPE_PARAMETER_NAME = "server-type";
    public static final String SERVER_NAME_PARAMETER_DESCRIPTION = "The name of the remote server.";
    public static final String SERVER_TYPE_PARAMETER_DESCRIPTION = "The type of the remote server (e.g. ldap or crowd).";

    public static String buildAuthenticator(String authenticatorIdentifier, String serverName) {
        return authenticatorIdentifier + ":" + serverName;
    }

    public static List<String> getServerNames(EAuthenticationTool tool, ServerOptionIndex optionIndex) throws StorageException {
        ArrayList<String> serverNames = new ArrayList<String>();
        ServerOptionRegistry serverRegistry = ServerOptionRegistry.getInstance();
        for (String entry : serverRegistry.getServerOptions(AuthenticationToolUtils.getOptionName(tool), optionIndex).keySet()) {
            if (!entry.contains("/")) continue;
            serverNames.add(entry.replace("/", ""));
        }
        return serverNames;
    }

    public static String getOptionName(EAuthenticationTool authenticationTool) {
        return switch (authenticationTool) {
            default -> throw new MatchException(null, null);
            case EAuthenticationTool.SAML -> "auth.saml";
            case EAuthenticationTool.LDAP -> "auth.ldap.server";
            case EAuthenticationTool.CROWD -> "auth.crowd.server";
            case EAuthenticationTool.TFS -> "auth.tfs.server";
            case EAuthenticationTool.GITHUB -> "auth.github.server";
            case EAuthenticationTool.TEAMSCALE -> "auth.teamscale.server";
        };
    }

    public static IAuthenticationToolProvider getProvider(EAuthenticationTool authenticationTool, GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        return switch (authenticationTool) {
            case EAuthenticationTool.CROWD -> new CrowdProvider(globalStorageSystem, messageBroker);
            case EAuthenticationTool.LDAP -> new LDAPProvider(globalStorageSystem, messageBroker);
            case EAuthenticationTool.GITHUB -> new GitHubProvider(globalStorageSystem, messageBroker);
            case EAuthenticationTool.TFS -> new TfsAuthorizationProvider(globalStorageSystem, messageBroker);
            case EAuthenticationTool.SAML -> new SamlAuthenticationProvider(globalStorageSystem);
            default -> {
                CCSMAssert.fail((String)"Authentication tool is not supported");
                yield null;
            }
        };
    }

    public static <T extends IOption> Pair<String, T> determineConnectOption(String optionName, String serverName, ServerOptionIndex optionIndex, Class<T> optionClazz) throws StorageException {
        if (StringUtils.isEmpty((String)serverName)) {
            Set<Map.Entry<String, IOption>> allOptionValues = ServerOptionRegistry.getServerMultiOptionAll(optionName, optionIndex).entrySet();
            if (allOptionValues.isEmpty()) {
                throw new BadRequestException(AuthenticationToolUtils.appendAlternativeLoginText("Connection type " + optionName + " is not configured!"));
            }
            if (allOptionValues.size() > 1) {
                throw new BadRequestException("A server name must be provided as there are multiple servers specified for connection type " + optionName + ".");
            }
            Map.Entry randomEntry = (Map.Entry)CollectionUtils.getAny(allOptionValues);
            serverName = (String)OptionRegistryBase.extractOptionNameAndSelector((String)Objects.requireNonNull(randomEntry).getKey()).getSecond();
            return new Pair((Object)serverName, (Object)((IOption)CCSMAssert.checkedCast(randomEntry.getValue(), optionClazz)));
        }
        T option = ServerOptionRegistry.getInstance().getServerMultiOption(optionName, serverName, optionClazz, optionIndex);
        if (option == null) {
            throw new BadRequestException(AuthenticationToolUtils.appendAlternativeLoginText("Connection type " + optionName + " of name " + serverName + " not found!"));
        }
        return new Pair((Object)serverName, option);
    }

    public static String appendAlternativeLoginText(String errorMessage) {
        return errorMessage + " If this issue persists please contact your administrator and use the direct login (i.e. 'Use direct login' below) with your Open Directory credentials instead.";
    }

    public static boolean isExternalAuthenticatorIdentifier(String identifier) {
        return switch (identifier) {
            case "HashedStored", "DenyAll", "AcceptAll" -> false;
            default -> true;
        };
    }
}

