/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolStrategyBase;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;

public abstract class SynchronizeUserGroupsStrategyBase<ServerDescription extends ServerDescriptionBase>
extends AuthenticationToolStrategyBase<ServerDescription>
implements ISynchronizeUserGroupsStrategy {
    private final UserGroupIndex groupIndex;

    protected SynchronizeUserGroupsStrategyBase(NamedServer<ServerDescription> server, UserGroupIndex groupIndex) {
        super(server);
        this.groupIndex = groupIndex;
    }

    @Override
    public List<String> synchronizeUserGroups(User user) throws StorageException, AuthenticationToolException {
        Set<String> remoteGroups = this.getRemoteGroups(user);
        List<UserGroup> existingGroups = this.groupIndex.getAllUserGroups().getSecondList().stream().filter(userGroup -> userGroup.originatesFrom(((ServerDescriptionBase)this.getServer().serverDescription()).getAuthenticationTool(), this.getServer().name())).toList();
        ArrayList<String> groupsToAdd = new ArrayList<String>();
        ArrayList<String> groupsToRemove = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        for (UserGroup group : existingGroups) {
            String username = user.getUsername();
            String remoteGroup = Optional.ofNullable(group.getRemoteGroup()).orElseGet(group::getName);
            if (group.containsUser(username) && !remoteGroups.contains(remoteGroup)) {
                groupsToRemove.add(group.getName());
            } else if (!group.containsUser(username) && remoteGroups.contains(remoteGroup)) {
                groupsToAdd.add(group.getName());
            }
            if (!remoteGroups.contains(remoteGroup)) continue;
            result.add(remoteGroup);
        }
        UserGroupUtils.addUserToGroups(user, groupsToAdd, this.groupIndex);
        UserGroupUtils.removeUserFromGroups(user, groupsToRemove, this.groupIndex);
        return result;
    }

    protected abstract Set<String> getRemoteGroups(User var1) throws StorageException, AuthenticationToolException;
}

