/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.teamscale.accesskeys;

import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="access-keys-encrypted", options={EStorageOption.BACKUP, EStorageOption.ENCRYPTED})
public class EncryptedAccessKeyIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "access-keys-encrypted";
    private final ValueIndex<ArrayList<AccessKey>> delegate;

    public EncryptedAccessKeyIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @NonNull List<AccessKey> getAccessKeys(String username) throws StorageException {
        String usernameKey = EncryptedAccessKeyIndex.computeKey(username);
        ArrayList accessKeys = (ArrayList)this.delegate.getValue(usernameKey);
        return CollectionUtils.emptyIfNull((List)accessKeys);
    }

    public void addAccessKey(String username, AccessKey accessKey) throws StorageException {
        String usernameKey = EncryptedAccessKeyIndex.computeKey(username);
        ArrayList<AccessKey> accessKeys = (ArrayList<AccessKey>)this.delegate.getValue(usernameKey);
        if (accessKeys == null) {
            accessKeys = new ArrayList<AccessKey>();
        }
        accessKeys.add(accessKey);
        this.delegate.setValue(usernameKey, accessKeys);
    }

    public void addAccessKeys(PairList<String, ArrayList<AccessKey>> accessKeysByUsername) throws StorageException {
        PairList accessKeysByUsernameLowercase = new PairList();
        for (Pair entry : accessKeysByUsername) {
            String usernameKey = EncryptedAccessKeyIndex.computeKey((String)entry.getFirst());
            accessKeysByUsernameLowercase.add(new Pair((Object)usernameKey, (Object)((ArrayList)entry.getSecond())));
        }
        this.delegate.setOrMergeValues(accessKeysByUsernameLowercase, (x$0, xva$1) -> CollectionUtils.unionList((Collection)x$0, (Collection[])new Collection[]{xva$1}));
    }

    public void removeAccessKey(String username) throws StorageException {
        this.delegate.removeValue(EncryptedAccessKeyIndex.computeKey(username));
    }

    public void removeAccessKeys(String username, Set<String> ids) throws StorageException {
        String usernameKey = EncryptedAccessKeyIndex.computeKey(username);
        ArrayList accessKeys = (ArrayList)this.delegate.getValue(usernameKey);
        if (accessKeys == null) {
            return;
        }
        accessKeys.removeIf(a -> ids.contains(a.getId().toString()));
        this.delegate.setValue(usernameKey, (Object)accessKeys);
    }

    private static String computeKey(String username) {
        return username.toLowerCase();
    }
}

