/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolProviderBase;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IAutoCompletionStrategy;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationServerDescription;
import com.teamscale.core.authenticate.tfs.TfsGroupAutoCompletionStrategy;
import com.teamscale.core.authenticate.tfs.TfsImportGroupsStrategy;
import com.teamscale.core.authenticate.tfs.TfsImportUsersStrategy;
import com.teamscale.core.authenticate.tfs.TfsSynchronizeGroupsAsyncStrategy;
import com.teamscale.core.authenticate.tfs.TfsSynchronizeUserGroupsStrategy;
import com.teamscale.core.authenticate.tfs.TfsSynchronizeUsersStrategy;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;

public class TfsAuthorizationProvider
extends AuthenticationToolProviderBase<TfsAuthorizationServerDescription> {
    public TfsAuthorizationProvider(GlobalStorageSystem globalStorageSystem, IMessageBroker messageBroker) {
        super(globalStorageSystem, messageBroker);
    }

    @Override
    public IImportUsersStrategy createImportUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new TfsImportUsersStrategy(this.getServer(serverName));
    }

    @Override
    public IImportGroupsStrategy createImportGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        NamedServer<TfsAuthorizationServerDescription> server = this.getServer(serverName);
        return new TfsImportGroupsStrategy(server, this.getCredentials(server), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(UserIndex.class), this.getMessageBroker(), (FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException>)((FunctionWithException)x$0 -> this.getToolProvider((EAuthenticationTool)((Object)x$0))));
    }

    @Override
    public ISynchronizeUsersStrategy createSynchronizeUsersStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return new TfsSynchronizeUsersStrategy(this.getServer(serverName), this.openGlobalIndex(UserIndex.class));
    }

    @Override
    public ISynchronizeGroupsStrategy createSynchronizeGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        NamedServer<TfsAuthorizationServerDescription> server = this.getServer(serverName);
        return new TfsSynchronizeGroupsAsyncStrategy(server, this.getCredentials(server), this.openGlobalIndex(UserIndex.class), this.openGlobalIndex(UserGroupIndex.class), this.openGlobalIndex(GlobalAnalysisProgressIndex.class), this.createImportGroupsStrategy(serverName), this.getMessageBroker());
    }

    @Override
    public ISynchronizeUserGroupsStrategy createSynchronizeUserGroupsStrategy(String serverName) throws StorageException, AuthenticationToolException {
        NamedServer<TfsAuthorizationServerDescription> server = this.getServer(serverName);
        ExternalCredentials credentials = this.getCredentials(server);
        return new TfsSynchronizeUserGroupsStrategy(server, credentials, this.openGlobalIndex(UserGroupIndex.class));
    }

    @Override
    public IAutoCompletionStrategy createUserAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        return IAutoCompletionStrategy.empty();
    }

    @Override
    public IAutoCompletionStrategy createGroupAutoCompletionStrategy(String serverName) throws StorageException, AuthenticationToolException {
        NamedServer<TfsAuthorizationServerDescription> server = this.getServer(serverName);
        return new TfsGroupAutoCompletionStrategy(server, this.getCredentials(server));
    }

    @Override
    public Class<TfsAuthorizationServerDescription> getServerDescriptionClass() {
        return TfsAuthorizationServerDescription.class;
    }

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.TFS;
    }

    private ExternalCredentials getCredentials(NamedServer<TfsAuthorizationServerDescription> server) throws StorageException, AuthenticationToolClientException {
        ExternalCredentialsIndex externalCredentialsIndex = this.openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials credentials = server.serverDescription().getAccountCredentials(externalCredentialsIndex);
        if (credentials == null) {
            throw new AuthenticationToolClientException("Account '" + server.serverDescription().accountCredentialsName + "' is not set up");
        }
        return credentials;
    }
}

