/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.google.common.collect.Streams;
import com.microsoft.tfs.core.clients.webservices.GroupWellKnownSIDConstants;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.IdentitySearchFactor;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.tfs.TfsConnection;
import com.teamscale.core.tfs.TfsException;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TfsAuthorizationUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentMap<String, Set<String>> GROUP_CACHE = new ConcurrentHashMap<String, Set<String>>();
    private static final Object LOCK = new Object();
    private static Instant groupCacheInvalidation = Instant.EPOCH;

    public static Set<String> getAllGroupNames(ExternalCredentials serverCredentials) throws AuthenticationToolException {
        TfsAuthorizationUtils.clearGroupCacheIfRequired();
        try {
            return (Set)CollectionUtils.computeIfAbsentWithException(GROUP_CACHE, (Object)serverCredentials.uri, key -> TfsAuthorizationUtils.computeNewGroup(serverCredentials));
        }
        catch (TfsException e) {
            throw new AuthenticationToolException("Could not read groups from TFS server", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearGroupCacheIfRequired() {
        Instant now = DateTimeUtils.now();
        Object object = LOCK;
        synchronized (object) {
            if (now.isAfter(groupCacheInvalidation)) {
                groupCacheInvalidation = now.plus(DurationUtils.ONE_HOUR);
                GROUP_CACHE.clear();
            }
        }
    }

    private static Set<String> computeNewGroup(ExternalCredentials serverCredentials) throws TfsException {
        try (TfsConnection connection = new TfsConnection(serverCredentials);){
            IIdentityManagementService2 identityService = connection.getIdentityManagementServiceClient();
            TeamFoundationIdentity rootIdentity = TfsAuthorizationUtils.findGroupById(identityService, GroupWellKnownSIDConstants.EVERYONE_GROUP_SID);
            IdentityDescriptor[] groupDescriptors = (IdentityDescriptor[])Arrays.stream(rootIdentity.getMembers()).filter(c -> "Microsoft.TeamFoundation.Identity".equals(c.getIdentityType())).toArray(IdentityDescriptor[]::new);
            TeamFoundationIdentity[] groupIdentities = TfsAuthorizationUtils.getIdentities(identityService, groupDescriptors);
            Set<String> set = Stream.concat(Stream.of(rootIdentity), Arrays.stream(groupIdentities)).filter(TeamFoundationIdentity::isContainer).map(TeamFoundationIdentity::getDisplayName).collect(Collectors.toSet());
            return set;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<UserGroup> findGroupByName(ExternalCredentials serverCredentials, String serverName, String groupName) throws AuthenticationToolException {
        try (TfsConnection connection = new TfsConnection(serverCredentials);){
            TeamFoundationIdentity identity = connection.getIdentityManagementServiceClient().readIdentity(IdentitySearchFactor.DISPLAY_NAME, groupName, MembershipQuery.NONE, ReadIdentityOptions.NONE);
            if (identity == null) {
                Optional<UserGroup> optional = Optional.empty();
                return optional;
            }
            Optional<UserGroup> optional = Optional.of(new UserGroup(identity.getDisplayName(), EAuthenticationTool.TFS, identity.getDescriptor().getIdentifier(), serverName));
            return optional;
        }
        catch (TfsException e) {
            throw new AuthenticationToolException("Could not retrieve group '" + groupName + "' from TFS server", (Throwable)((Object)e));
        }
    }

    public static TeamFoundationIdentity findGroupById(ExternalCredentials serverCredentials, UserGroup group) throws AuthenticationToolException {
        TfsConnection connection = new TfsConnection(serverCredentials);
        try {
            TeamFoundationIdentity teamFoundationIdentity = TfsAuthorizationUtils.findGroupById(connection.getIdentityManagementServiceClient(), group.getRemoteGroup());
            connection.close();
            return teamFoundationIdentity;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve group '" + group.getRemoteGroup() + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    public static Set<String> getUsersForGroup(ExternalCredentials serverCredentials, UserGroup group, String userLoginName) throws AuthenticationToolException {
        TfsConnection connection = new TfsConnection(serverCredentials);
        try {
            IIdentityManagementService2 identityService = connection.getIdentityManagementServiceClient();
            TeamFoundationIdentity groupIdentity = TfsAuthorizationUtils.findGroupById(identityService, group.getRemoteGroup());
            Set<String> set = Arrays.stream(TfsAuthorizationUtils.getIdentities(identityService, groupIdentity.getMembers())).filter(identity -> !identity.isContainer()).map(identity -> TfsAuthorizationUtils.getQueryableUserId(identity, userLoginName)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            connection.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve members of group '" + group.getRemoteGroup() + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    public static Set<String> getGroupsForUser(ExternalCredentials serverCredentials, User user) throws AuthenticationToolException {
        TfsConnection connection = new TfsConnection(serverCredentials);
        try {
            IIdentityManagementService2 identityService = connection.getIdentityManagementServiceClient();
            Optional<TeamFoundationIdentity> userIdentity = TfsAuthorizationUtils.findUser(user, identityService);
            if (userIdentity.isEmpty()) {
                throw new AuthenticationEntityNotFoundException("User '%s' not found!".formatted(user.getUsername()));
            }
            Set<String> set = Arrays.stream(TfsAuthorizationUtils.getIdentities(identityService, userIdentity.get().getMemberOf())).filter(TeamFoundationIdentity::isContainer).map(identity -> identity.getDescriptor().getIdentifier()).collect(Collectors.toSet());
            connection.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TfsException e) {
                throw new AuthenticationToolException("Could not retrieve groups of user '" + user.getUsername() + "' from TFS server", (Throwable)((Object)e));
            }
        }
    }

    private static Optional<TeamFoundationIdentity> findUser(User user, IIdentityManagementService2 identityService) {
        TeamFoundationIdentity userIdentity = identityService.readIdentity(IdentitySearchFactor.ACCOUNT_NAME, user.getUsername(), MembershipQuery.EXPANDED, ReadIdentityOptions.NONE);
        if (userIdentity == null && user.getUsername().contains("@")) {
            userIdentity = identityService.readIdentity(IdentitySearchFactor.MAIL_ADDRESS, user.getUsername(), MembershipQuery.EXPANDED, ReadIdentityOptions.NONE);
        }
        if (userIdentity == null && !StringUtils.isEmpty((String)user.getEmailAddress())) {
            userIdentity = identityService.readIdentity(IdentitySearchFactor.MAIL_ADDRESS, user.getEmailAddress(), MembershipQuery.EXPANDED, ReadIdentityOptions.NONE);
        }
        return Optional.ofNullable(userIdentity);
    }

    private static TeamFoundationIdentity[] getIdentities(IIdentityManagementService2 identityService, IdentityDescriptor[] descriptors) {
        return identityService.readIdentities(descriptors, MembershipQuery.NONE, ReadIdentityOptions.NONE, new String[0], IdentityPropertyScope.NONE);
    }

    private static TeamFoundationIdentity findGroupById(IIdentityManagementService2 identityService, String groupSid) {
        return identityService.readIdentity(IdentitySearchFactor.IDENTIFIER, groupSid, MembershipQuery.EXPANDED, ReadIdentityOptions.NONE);
    }

    private static Optional<String> getQueryableUserId(TeamFoundationIdentity identity, String userLoginName) {
        Optional<String> userId;
        if (!StringUtils.isEmpty((String)userLoginName)) {
            CaseInsensitiveStringSet propertyNames = new CaseInsensitiveStringSet();
            Streams.stream((Iterable)identity.getProperties()).forEach(entry -> propertyNames.add((String)entry.getKey()));
            return TfsAuthorizationUtils.getIdentityProperty(identity, propertyNames.get(userLoginName));
        }
        if ("System.Security.Principal.WindowsIdentity".equals(identity.getDescriptor().getIdentityType()) && (userId = TfsAuthorizationUtils.getIdentityProperty(identity, "DN")).isPresent()) {
            return userId;
        }
        userId = TfsAuthorizationUtils.getIdentityProperty(identity, "Mail");
        if (userId.isPresent()) {
            return userId;
        }
        return Optional.of(identity.getUniqueName());
    }

    private static Optional<String> getIdentityProperty(TeamFoundationIdentity identity, String name) {
        Object property = identity.getProperty(name);
        if (property != null && !(property instanceof String)) {
            LOGGER.warn("Received a non-string property value for " + name + ", ignoring: " + String.valueOf(property));
            return Optional.empty();
        }
        String value = (String)property;
        if (StringUtils.isEmpty((String)value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

