/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.text.filter.base.Deletion;

public class FindingsDeletionFilterUtils {
    public static List<IndexFinding> filterFindings(List<IndexFinding> findings, List<Deletion> filterDeletions, int elementLength) {
        if (findings.isEmpty()) {
            return new ArrayList<IndexFinding>(findings);
        }
        Predicate<DetachedFinding> filter = FindingsDeletionFilterUtils.createDeletionFilter(filterDeletions, elementLength);
        ArrayList<IndexFinding> result = new ArrayList<IndexFinding>();
        for (IndexFinding finding : findings) {
            if (!filter.test((DetachedFinding)finding)) continue;
            result.add(finding);
        }
        return result;
    }

    public static Predicate<DetachedFinding> createDeletionFilter(List<Deletion> filterDeletions, int elementLength) {
        boolean fullFileCoveredByDeletion;
        if (filterDeletions == null || filterDeletions.isEmpty()) {
            return finding -> true;
        }
        List compactedDeletions = Deletion.compactDeletions(filterDeletions);
        boolean bl = fullFileCoveredByDeletion = compactedDeletions.size() == 1 && ((Deletion)compactedDeletions.get(0)).getStartOffset() == 0 && ((Deletion)compactedDeletions.get(0)).getEndOffset() >= elementLength;
        if (fullFileCoveredByDeletion) {
            return finding -> false;
        }
        return finding -> !FindingsDeletionFilterUtils.isFiltered(finding, compactedDeletions);
    }

    private static boolean isFiltered(DetachedFinding finding, List<Deletion> filterDeletions) {
        if (!(finding.getLocation() instanceof TextRegionLocation)) {
            return false;
        }
        TextRegionLocation location = (TextRegionLocation)finding.getLocation();
        for (Deletion deletion : filterDeletions) {
            if (!deletion.covers(location)) continue;
            return true;
        }
        return false;
    }
}

