/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import eu.cqse.check.framework.core.registry.GuidelineMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class IndexFindingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void fillInMissingOffsets(IndexFinding finding, String fileContent, LineOffsetConverter converter) {
        if (finding.getLocation() instanceof TextRegionLocation) {
            TextRegionLocation textRegionLocation = (TextRegionLocation)finding.getLocation();
            if (IndexFindingUtils.hasValidOffsets(textRegionLocation)) {
                return;
            }
            finding.setLocation((ElementLocation)IndexFindingUtils.fillInMissingOffsets(textRegionLocation, converter, fileContent));
        }
    }

    public static boolean hasValidOffsets(TextRegionLocation location) {
        return location.getRawStartOffset() != -1 && location.getRawEndOffset() != -1;
    }

    public static TextRegionLocation fillInMissingOffsets(TextRegionLocation location, LineOffsetConverter converter, String fileContent) {
        int startOffset = converter.getOffset(location.getRawStartLine());
        int endOffset = fileContent.length();
        if (location.getRawEndLine() < converter.getLineCount()) {
            endOffset = converter.getOffset(location.getRawEndLine() + 1) - 1;
        }
        if (endOffset < startOffset) {
            LOGGER.warn("Incorrect offsets (start:" + startOffset + ", end:" + endOffset + "): " + location.toLocationString() + ". Setting end offset to start offset. ");
            endOffset = startOffset;
        }
        return new TextRegionLocation(location.getUniformPath(), startOffset, endOffset, location.getRawStartLine(), location.getRawEndLine());
    }

    public static <T extends DetachedFinding> List<T> adjustFindingLocations(LocationAdjuster adjuster, Collection<T> findings) {
        ArrayList<DetachedFinding> newFindings = new ArrayList<DetachedFinding>();
        for (DetachedFinding finding : findings) {
            ElementLocation newLocation = adjuster.adjustLocation(finding.getLocation());
            if (newLocation != null) {
                finding.setLocation(newLocation);
                newFindings.add(finding);
                continue;
            }
            LOGGER.warn("Could not adjust the finding's location: " + String.valueOf(finding));
        }
        return newFindings;
    }

    public static void setGuidelineMapping(IndexFinding finding, String checkID, ELanguage language) {
        IndexFindingUtils.setGuidelineMapping(finding, checkID, Set.of(language));
    }

    public static void setGuidelineMapping(IndexFinding finding, String checkID, Set<ELanguage> languages) {
        SetMap rulesByGuidelineID = GuidelineMapping.getInstance().getRulesByGuidelineName(checkID, languages);
        if (!rulesByGuidelineID.isEmpty()) {
            finding.setGuidelineMapping(rulesByGuidelineID);
        }
    }
}

