/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.core.log.LogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.js.DetailedJavaScriptErrorLog;
import com.teamscale.core.log.profiler.DetailedProfilerLog;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=DetailedWorkerLog.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DetailedJavaScriptErrorLog.class, name="DetailedJavaScriptErrorLog"), @JsonSubTypes.Type(value=DetailedServiceLog.class, name="DetailedServiceLog"), @JsonSubTypes.Type(value=DetailedProfilerLog.class, name="DetailedProfilerLog"), @JsonSubTypes.Type(value=DetailedWorkerLog.class, name="DetailedWorkerLog")})
@IndexValueClass
public abstract class DetailedLogEntryBase
extends LogEntryBase {
    private static final long serialVersionUID = 1L;
    protected static final String LOGGING_EVENTS_PROPERTY_NAME = "loggingEvents";
    @JsonProperty(value="loggingEvents")
    private final List<LoggingEventTransport> loggingEvents = new ArrayList<LoggingEventTransport>();

    protected DetailedLogEntryBase(LogEntryIdentifier identifier, Collection<LoggingEventTransport> loggingEvents) {
        super(identifier);
        this.loggingEvents.addAll(loggingEvents);
    }

    public UnmodifiableList<LoggingEventTransport> getLoggingEvents() {
        return CollectionUtils.asUnmodifiable(this.loggingEvents);
    }

    public final boolean matches(Pattern pattern) {
        return this.getFilterCriteria().filter(Objects::nonNull).map(pattern::matcher).anyMatch(Matcher::find);
    }

    protected Stream<String> getFilterCriteria() {
        long timestamp = this.getTimestamp();
        return Stream.concat(Stream.of(Long.toString(timestamp), new Date(timestamp).toString()), this.loggingEvents.stream().flatMap(event -> Stream.of(event.getMessage())));
    }

    public Stream<String> getFormattedLogEntry() {
        return this.getLoggingEvents().stream().map(event -> "\t%s\t %s".formatted(event.getLevel(), event.getMessage()));
    }
}

