/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import java.util.Arrays;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public class ShortServiceLog
extends ShortLogEntryBase {
    private static final long serialVersionUID = 1L;
    public static final String TARGET_PROPERTY_NAME = "target";
    public static final String HTTP_METHOD_PROPERTY_NAME = "httpMethod";
    public static final String USERNAME_PROPERTY_NAME = "username";
    public static final String PARAMETERS_PROPERTY_NAME = "parameters";
    @JsonProperty(value="target")
    public final String target;
    @JsonProperty(value="httpMethod")
    public final @Nullable String httpMethod;
    @JsonProperty(value="username")
    public final String username;
    @JsonProperty(value="parameters")
    public final String parameters;

    public ShortServiceLog(LogEntryIdentifier id, String target, @Nullable String httpMethod, String username, String parameters, int debugCount, int fatalCount, int errorCount, int warningCount, InternalProjectId projectId) {
        super(id, debugCount, fatalCount, errorCount, warningCount, (IProjectId)projectId);
        this.target = target;
        this.httpMethod = httpMethod;
        this.parameters = parameters;
        this.username = username;
    }

    @JsonCreator
    @VisibleForTesting
    protected ShortServiceLog(@JsonProperty(value="id") LogEntryIdentifier id, @JsonProperty(value="target") String target, @JsonProperty(value="httpMethod") @Nullable String httpMethod, @JsonProperty(value="username") String username, @JsonProperty(value="parameters") String parameters, @JsonProperty(value="debugCount") int debugCount, @JsonProperty(value="fatalCount") int fatalCount, @JsonProperty(value="errorCount") int errorCount, @JsonProperty(value="warningCount") int warningCount, @JsonProperty(value="projectName") PublicProjectId projectId) {
        super(id, debugCount, fatalCount, errorCount, warningCount, (IProjectId)projectId);
        this.target = target;
        this.httpMethod = httpMethod;
        this.parameters = parameters;
        this.username = username;
    }

    public String getTarget() {
        return this.target;
    }

    public String toString() {
        return StringUtils.concat(Arrays.asList(this.httpMethod, this.target, this.getProjectId(), this.parameters, this.username));
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.target, this.httpMethod, this.username, this.parameters));
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        super.appendFields(builder);
        builder.append(this.target).append(" ");
        builder.append(this.httpMethod).append(" ");
        builder.append(this.parameters).append(" ");
        builder.append(this.username).append(" ");
    }
}

