/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.schema;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class MetricSchemaIndexUtils {
    public static Map<String, MetricDirectorySchemaEntry> readSchema(MetricSchemaIndex metricSchemaIndex) throws StorageException {
        List<IMetricSource> metricSources = metricSchemaIndex.getMetricSources();
        MetricDirectorySchema schema = metricSchemaIndex.getSchema(false);
        CCSMAssert.isTrue((metricSources.size() == schema.getAllEntries().size() ? 1 : 0) != 0, (String)"Expecting sources and schema to be of same size!");
        HashMap<String, MetricDirectorySchemaEntry> schemaEntryByName = new HashMap<String, MetricDirectorySchemaEntry>();
        for (int i = 0; i < metricSources.size(); ++i) {
            IMetricSource metricSource = metricSources.get(i);
            if (!(metricSource instanceof IndexMetricSource)) continue;
            schemaEntryByName.put(((IndexMetricSource)metricSource).getMetricPartition(), schema.getEntry(i));
        }
        return schemaEntryByName;
    }
}

