/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.source;

import com.teamscale.core.metrics.source.DivisionMetricSource;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class RangedDivisionMetricSource
extends DivisionMetricSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final double minValue;
    private final double maxValue;

    public RangedDivisionMetricSource(int numeratorOffset, int denominatorOffset, double defaultValueIfDenominatorZero, double minValue, double maxValue) {
        super(numeratorOffset, denominatorOffset, defaultValueIfDenominatorZero, Collections.emptySet());
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    protected @Nullable Double calculateValue(double arg1, double arg2, @Nullable CodeScopeName codeScopeName) {
        Double calculatedValue = super.calculateValue(arg1, arg2, codeScopeName);
        if (calculatedValue == null) {
            return null;
        }
        if (calculatedValue < this.minValue) {
            LOGGER.error("Derived metric value " + calculatedValue + " calculated from " + arg1 + " and " + arg2 + " is lower than expected (" + this.minValue + "). Fallback to " + this.minValue + ".");
            return this.minValue;
        }
        if (calculatedValue > this.maxValue) {
            LOGGER.error("Derived metric value " + calculatedValue + " calculated from " + arg1 + " and " + arg2 + " is higher than expected (" + this.maxValue + "). Fallback to " + this.maxValue + ".");
            return this.maxValue;
        }
        return calculatedValue;
    }
}

