/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;

@ExportToTypeScript
@Option(id="ts.shadow-mode", name="Shadow Mode", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=600)
@IndexValueClass(containedInBackup=true)
public class ShadowModeOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "ts.shadow-mode";
    public static final String OPTION_NAME = "Shadow Mode";
    @JsonProperty(value="enabled")
    @OptionFieldDescription(name="Enable Shadow Mode", description="Disables all notifications and data export of this Teamscale instance. This includes email notifications, merge request annotations, and ABAP imports. This does not include instance monitoring or automatic backups, i.e., shadow-mode instances write automatic backups.Use this option to setup a shadow instance of a running instance.")
    public boolean enabled = false;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public static boolean isShadowModeEnabled(GlobalStorageSystem globalStorageSystem) throws StorageException {
        return ShadowModeOption.isShadowModeEnabled((ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class));
    }

    public static boolean isShadowModeEnabled(ServerOptionIndex serverOptionIndex) throws StorageException {
        return ServerOptionRegistry.getInstance().getServerOption((String)OPTION_ID, ShadowModeOption.class, (ServerOptionIndex)serverOptionIndex).enabled;
    }

    @TestOnly
    public static void setShadowModeEnabled(boolean enabled, ServerOptionIndex serverOptionIndex) throws StorageException {
        ShadowModeOption option = new ShadowModeOption();
        option.enabled = enabled;
        ServerOptionRegistry.getInstance().putOption("server", OPTION_ID, null, option, serverOptionIndex);
    }
}

