/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompiler;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class TriggerCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<AnalysisTrigger> periodicTriggers = new ArrayList<AnalysisTrigger>();
    private final List<AnalysisTrigger> externalDataTriggers = new ArrayList<AnalysisTrigger>();
    private final List<AnalysisTrigger> postBuildCompletenessTriggers = new ArrayList<AnalysisTrigger>();
    private final List<ITrigger> parallelPrivilegedTriggers = new ArrayList<ITrigger>();
    private final Map<String, ITrigger> triggersByName = new HashMap<String, ITrigger>();
    private final ListMap<String, AnalysisTrigger> triggersByDelta = new ListMap();
    private final InternalProjectId projectId;
    private final IndexLayer indexLayer;

    public TriggerCache(InternalProjectId projectId, IndexLayer indexLayer) throws StorageException, TriggerCompilationException {
        this.projectId = projectId;
        this.indexLayer = indexLayer;
        this.loadTriggers();
    }

    public TriggerCache(AnalysisTrigger ... triggers) {
        this.projectId = null;
        this.indexLayer = null;
        Arrays.asList(triggers).forEach(this::insertTrigger);
    }

    public synchronized ITrigger getTrigger(ScheduledJob scheduledJob) throws TriggerCompilationException {
        return this.getTrigger(scheduledJob.getJob());
    }

    public synchronized ITrigger getTrigger(JobDescriptor job) throws TriggerCompilationException {
        return this.getTrigger(job.getTriggerName(), job.getTriggerType(), job.getInternalProjectId());
    }

    public synchronized ITrigger getTrigger(String triggerName, ETriggerType triggerType, InternalProjectId projectId) throws TriggerCompilationException {
        return this.findTrigger(triggerName, triggerType, projectId).orElseThrow(() -> {
            CCSMAssert.fail((String)("Fatal error. Trigger " + triggerName + " in project " + String.valueOf(projectId) + " of type " + String.valueOf((Object)triggerType) + " was null, but was not expected to be!"));
            throw null;
        });
    }

    public synchronized Optional<ITrigger> findTrigger(JobDescriptor job) throws TriggerCompilationException {
        return this.findTrigger(job.getTriggerName(), job.getTriggerType(), job.getInternalProjectId());
    }

    private synchronized Optional<ITrigger> findTrigger(String triggerName, ETriggerType triggerType, InternalProjectId projectId) throws TriggerCompilationException, AssertionError {
        ITrigger trigger = this.triggersByName.get(triggerName);
        if (trigger == null && triggerType == ETriggerType.PRIVILEGED) {
            trigger = PrivilegedTrigger.createTrigger(triggerName);
            this.triggersByName.put(triggerName, trigger);
            if (trigger.getConcurrency() == ETriggerConcurrency.MAINTENANCE_PARALLEL) {
                this.parallelPrivilegedTriggers.add(trigger);
            }
        }
        if (trigger == null && this.projectId != null && this.indexLayer != null) {
            LOGGER.warn("Trigger " + triggerName + " was missing in project " + String.valueOf(projectId) + ". Attempting trigger reload!");
            this.reload();
            trigger = this.triggersByName.get(triggerName);
        }
        if (trigger == null) {
            LOGGER.warn("Fatal error. Trigger " + triggerName + " in project " + String.valueOf(projectId) + " was null!");
        }
        return Optional.ofNullable(trigger);
    }

    private synchronized void loadTriggers() throws StorageException, TriggerCompilationException {
        if (this.projectId == null || this.indexLayer == null || SchedulingConstants.isMaintenance((IProjectId)this.projectId)) {
            return;
        }
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.projectId);
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        PairList<String, TriggerDescription> triggerDescriptions = ((TriggerIndex)projectStorageSystem.openProjectIndex(TriggerIndex.class, null)).getAllTriggers();
        Optional<String> errorMessage = TriggerCache.getEmptyTriggerErrorMessage(this.projectId, triggerDescriptions);
        if (errorMessage.isPresent()) {
            LOGGER.error(errorMessage.get());
            return;
        }
        List<AnalysisTrigger> triggers = new TriggerCompiler(projectStorageSystem.getSchema(), globalStorageSystem.getSchema()).compile(triggerDescriptions);
        for (AnalysisTrigger trigger : triggers) {
            this.insertTrigger(trigger);
        }
    }

    private void insertTrigger(AnalysisTrigger trigger) {
        this.triggersByName.put(trigger.getName(), trigger);
        for (String delta : trigger.getExpectedDeltaStoreNames()) {
            this.triggersByDelta.add((Object)delta, (Object)trigger);
        }
        if (trigger.isPeriodic()) {
            this.periodicTriggers.add(trigger);
        }
        if (trigger.isExternalDataTrigger()) {
            this.externalDataTriggers.add(trigger);
        }
        if (trigger.shouldRunPostBuildCompleteness()) {
            this.postBuildCompletenessTriggers.add(trigger);
        }
    }

    private static Optional<String> getEmptyTriggerErrorMessage(InternalProjectId projectId, PairList<String, TriggerDescription> triggerDescriptions) {
        ArrayList<Object> errors = new ArrayList<Object>();
        for (Pair triggerDescription : triggerDescriptions) {
            String name = (String)triggerDescription.getFirst();
            TriggerDescription description = (TriggerDescription)triggerDescription.getSecond();
            if (StringUtils.isEmpty((String)name) && description == null) {
                errors.add("Fatal: Empty name and empty description");
                continue;
            }
            if (StringUtils.isEmpty((String)name)) {
                errors.add("Empty name for description: " + String.valueOf(description));
                continue;
            }
            if (description != null) continue;
            errors.add("Empty description for trigger: " + name);
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Empty triggers for ").append(projectId).append(":");
        for (String error : errors) {
            errorMessage.append("\n").append(error);
        }
        return Optional.of(errorMessage.toString());
    }

    public synchronized List<AnalysisTrigger> getPeriodicTriggers() {
        return this.periodicTriggers;
    }

    public synchronized List<AnalysisTrigger> getExternalDataTriggers() {
        return this.externalDataTriggers;
    }

    public synchronized List<AnalysisTrigger> getPostBuildCompletenessTriggers() {
        return this.postBuildCompletenessTriggers;
    }

    public synchronized List<ITrigger> getParallelPrivilegedTriggers() {
        return this.parallelPrivilegedTriggers;
    }

    public synchronized Set<String> getAllDeltaStores() {
        return this.triggersByDelta.getKeys();
    }

    public synchronized List<AnalysisTrigger> getTriggersConsumingDelta(String storeName) {
        return (List)this.triggersByDelta.getCollectionOrEmpty((Object)storeName);
    }

    public synchronized void reload() {
        this.periodicTriggers.clear();
        this.externalDataTriggers.clear();
        this.postBuildCompletenessTriggers.clear();
        this.triggersByName.clear();
        this.triggersByDelta.clear();
        try {
            this.loadTriggers();
        }
        catch (TriggerCompilationException | StorageException e) {
            LOGGER.error("Reloading of trigger data failed: " + e.getMessage(), e);
        }
    }
}

