/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.image.attributes.ImageAttributesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.ext.task.list.items.TaskListItemsExtension;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.text.LineBreakRendering;
import org.commonmark.renderer.text.TextContentRenderer;
import org.conqat.lib.commons.lang.Markdown;
import org.conqat.lib.commons.string.StringUtils;

public class MarkdownUtils {
    private static final Parser PARSER;
    private static final HtmlRenderer HTML_RENDERER;
    private static final TextContentRenderer TEXT_RENDERER;

    private MarkdownUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String translateMarkdownToHtml(@Markdown @Nullable String markdown, @Nullable URI baseUrl) {
        if (StringUtils.isEmpty((String)markdown)) {
            return "";
        }
        Node node = PARSER.parse(markdown);
        if (baseUrl != null) {
            node.accept((Visitor)new UrlResolvingVisitor(baseUrl));
        }
        return HTML_RENDERER.render(node);
    }

    public static String translateMarkdownToText(@Markdown @Nullable String markdown) {
        if (StringUtils.isEmpty((String)markdown)) {
            return "";
        }
        Node node = PARSER.parse(markdown);
        return TEXT_RENDERER.render(node);
    }

    static {
        List<Extension> extensions = List.of(AutolinkExtension.create(), StrikethroughExtension.create(), TablesExtension.create(), InsExtension.create(), ImageAttributesExtension.create(), TaskListItemsExtension.create());
        PARSER = Parser.builder().extensions(extensions).build();
        HTML_RENDERER = HtmlRenderer.builder().extensions(extensions).sanitizeUrls(true).build();
        TEXT_RENDERER = TextContentRenderer.builder().extensions(extensions).lineBreakRendering(LineBreakRendering.SEPARATE_BLOCKS).build();
    }

    private static class UrlResolvingVisitor
    extends AbstractVisitor {
        private final URI baseUrl;

        public UrlResolvingVisitor(URI baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
        }

        private String resolveUrl(String destination) {
            if (StringUtils.isEmpty((String)destination)) {
                return destination;
            }
            return this.baseUrl.resolve(StringUtils.stripPrefix((String)destination, (String)"/")).toString();
        }

        public void visit(Image image) {
            image.setDestination(this.resolveUrl(image.getDestination()));
            super.visit(image);
        }

        public void visit(Link link) {
            link.setDestination(this.resolveUrl(link.getDestination()));
            super.visit(link);
        }
    }
}

