/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import java.lang.management.ManagementFactory;
import java.util.List;

public class RamUtils {
    private static final int ONE_KILO_BYTE_VALUE = 1024;
    public static final int BYTES_PER_MEGABYTE = 0x100000;
    public static final int BYTES_PER_GIGABYTE = 0x40000000;
    public static final int TEAMSCALE_WORKER_REQUIRED_RAM = 2048;

    public static boolean hasSufficientRam(int numWorkers, long availableRam) {
        if (numWorkers <= 0) {
            return true;
        }
        return availableRam / (long)numWorkers >= 2048L;
    }

    public static long getRamSizeMB(String xmxArgument) {
        String lowerCasedArgument;
        String ramSize = lowerCasedArgument = xmxArgument.toLowerCase();
        if (lowerCasedArgument.endsWith("m") || lowerCasedArgument.endsWith("g") || lowerCasedArgument.endsWith("k")) {
            ramSize = lowerCasedArgument.substring(0, lowerCasedArgument.length() - 1);
        }
        long toBeConverted = Long.parseLong(ramSize);
        if (lowerCasedArgument.endsWith("m")) {
            return toBeConverted;
        }
        if (lowerCasedArgument.endsWith("g")) {
            return toBeConverted * 1024L;
        }
        if (lowerCasedArgument.endsWith("k")) {
            return toBeConverted / 1024L;
        }
        return toBeConverted / 1024L / 1024L;
    }

    public static String getXmxArgument() {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String argument : arguments) {
            if (!argument.startsWith("-Xmx")) continue;
            return argument.substring(4);
        }
        return String.valueOf(Runtime.getRuntime().maxMemory());
    }
}

