/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class Assessment
implements Cloneable,
Serializable,
Comparable<Assessment> {
    private static final long serialVersionUID = 1L;
    public static final String MAPPING_PROPERTY = "mapping";
    @JsonProperty(value="mapping")
    private final int[] mapping = new int[ETrafficLightColor.values().length];
    public static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance(Locale.US);

    @JsonCreator
    public Assessment() {
    }

    public Assessment(ETrafficLightColor color) {
        this.add(color);
    }

    public Assessment(Assessment assessment) {
        this.add(assessment);
    }

    public int getSize() {
        return Arrays.stream(this.mapping).map(Math::abs).sum();
    }

    public final void add(ETrafficLightColor color) {
        this.add(color, 1);
    }

    public final void add(ETrafficLightColor color, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative!");
        }
        int n = color.ordinal();
        this.mapping[n] = this.mapping[n] + count;
    }

    public final void add(Assessment a) {
        for (int i = 0; i < this.mapping.length; ++i) {
            int n = i;
            this.mapping[n] = this.mapping[n] + a.mapping[i];
        }
    }

    public final void subtract(Assessment a) {
        for (int i = 0; i < this.mapping.length; ++i) {
            int n = i;
            this.mapping[n] = this.mapping[n] - a.mapping[i];
            if (this.mapping[i] >= 0) continue;
            this.mapping[i] = 0;
        }
    }

    public int getColorFrequency(ETrafficLightColor color) {
        return this.mapping[color.ordinal()];
    }

    public double getRelativeColorFrequency(ETrafficLightColor color) {
        int size = this.getSize();
        if (size == 0) {
            return 0.0;
        }
        return (double)this.getColorFrequency(color) / (double)size;
    }

    public ETrafficLightColor getDominantColor() {
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            if (this.mapping[color.ordinal()] <= 0) continue;
            return color;
        }
        return ETrafficLightColor.UNKNOWN;
    }

    public ETrafficLightColor getMostFrequentColor() {
        ETrafficLightColor result = ETrafficLightColor.UNKNOWN;
        int bestCount = 0;
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            int count = this.mapping[color.ordinal()];
            if (count <= bestCount) continue;
            bestCount = count;
            result = color;
        }
        return result;
    }

    public String toString() {
        int sum = this.getSize();
        if (sum == 0) {
            return "";
        }
        if (sum == 1) {
            return this.getDominantColor().toString();
        }
        StringBuilder builder = new StringBuilder("[");
        this.appendColor(builder, ETrafficLightColor.GREEN);
        builder.append(", ");
        this.appendColor(builder, ETrafficLightColor.YELLOW);
        builder.append(", ");
        this.appendColor(builder, ETrafficLightColor.RED);
        if (this.getColorFrequency(ETrafficLightColor.BASELINE) > 0) {
            builder.append(", ");
            this.appendColor(builder, ETrafficLightColor.BASELINE);
        }
        if (this.getColorFrequency(ETrafficLightColor.ORANGE) > 0) {
            builder.append(", ");
            this.appendColor(builder, ETrafficLightColor.ORANGE);
        }
        builder.append("]");
        return builder.toString();
    }

    private void appendColor(StringBuilder builder, ETrafficLightColor color) {
        builder.append(color.getAssessmentDisplayName());
        builder.append(": ");
        builder.append(this.getColorFrequency(color));
    }

    public String toFormattedColors() {
        int sum = this.getSize();
        if (sum == 0) {
            return "[]";
        }
        ArrayList<String> builder = new ArrayList<String>();
        for (ETrafficLightColor color : ETrafficLightColor.getTrafficLightColors()) {
            if (this.getColorFrequency(color) <= 0) continue;
            builder.add(this.computeFormattedColor(color, sum));
        }
        return "[" + String.join((CharSequence)", ", builder) + "]";
    }

    private String computeFormattedColor(ETrafficLightColor color, int sum) {
        String colorName = color.getAssessmentDisplayName();
        int colorAbsoluteValue = this.getColorFrequency(color);
        String colorRelativeValue = PERCENT_FORMAT.format((double)this.getColorFrequency(color) / (double)sum);
        return colorName + ": " + colorAbsoluteValue + " (" + colorRelativeValue + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Assessment)) {
            return false;
        }
        return Arrays.equals(this.mapping, ((Assessment)obj).mapping);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            hash *= 97;
            hash += this.mapping[i];
            hash %= 0x3000005;
        }
        return hash;
    }

    @Override
    public int compareTo(@NonNull Assessment other) {
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] == other.mapping[i]) continue;
            return this.mapping[i] - other.mapping[i];
        }
        return 0;
    }

    public static Assessment aggregate(Collection<Assessment> values) {
        Assessment result = new Assessment();
        for (Assessment a : values) {
            result.add(a);
        }
        return result;
    }

    public CounterSet<ETrafficLightColor> toCounterSet() {
        CounterSet<ETrafficLightColor> result = new CounterSet<ETrafficLightColor>();
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            result.inc(color, this.mapping[color.ordinal()]);
        }
        return result;
    }

    static {
        PERCENT_FORMAT.setMinimumFractionDigits(1);
        PERCENT_FORMAT.setMaximumFractionDigits(1);
    }
}

