/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Stack;
import org.conqat.lib.commons.collections.ISortableData;

public class SortableDataUtils {
    public static int binarySearch(ISortableData data, int elementIndex) {
        int lower = 0;
        int upper = data.size();
        while (lower < upper) {
            int mid = lower + upper >>> 1;
            if (data.isLess(mid, elementIndex)) {
                lower = mid + 1;
                continue;
            }
            upper = mid;
        }
        return lower;
    }

    public static void sort(ISortableData data) {
        if (data.size() < 5) {
            SortableDataUtils.bubbleSort(data, 0, data.size());
            return;
        }
        SortableDataUtils.quickSort(data);
    }

    private static void quickSort(ISortableData data) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        stack.push(data.size());
        while (!stack.isEmpty()) {
            int start;
            int end = (Integer)stack.pop();
            if (end - (start = ((Integer)stack.pop()).intValue()) < 2) continue;
            int pivot = start + (end - start) / 2;
            pivot = SortableDataUtils.partition(data, start, end, pivot);
            stack.push(pivot + 1);
            stack.push(end);
            stack.push(start);
            stack.push(pivot);
        }
    }

    private static int partition(ISortableData data, int begin, int end, int pivot) {
        int lower = begin;
        int upper = end - 1;
        while (lower <= upper) {
            if (data.isLess(lower, pivot)) {
                ++lower;
                continue;
            }
            pivot = SortableDataUtils.swapFixPivot(data, lower, upper, pivot);
            --upper;
        }
        if (lower != pivot) {
            data.swap(lower, pivot);
        }
        return lower;
    }

    private static int swapFixPivot(ISortableData data, int i, int j, int pivot) {
        data.swap(i, j);
        if (i == pivot) {
            return j;
        }
        if (j == pivot) {
            return i;
        }
        return pivot;
    }

    static void bubbleSort(ISortableData data, int begin, int end) {
        for (int i = end - 1; i > begin; --i) {
            for (int j = begin; j < i; ++j) {
                if (!data.isLess(j + 1, j)) continue;
                data.swap(j, j + 1);
            }
        }
    }
}

