/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.lang;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public class ObjectUtils {
    public static <T extends Comparable<T>> int compareNullSafe(T object1, T object2) {
        return ObjectUtils.compareNullSafe(object1, object2, Comparable::compareTo);
    }

    public static <T> int compareNullSafe(T object1, T object2, Comparator<T> comparator) {
        if (object1 == object2) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return comparator.compare(object1, object2);
    }

    @Contract(value="null,_ -> fail", pure=true)
    public static <T> @NonNull T requireNonNull(@Nullable T reference, @NonNull String referenceName) throws NullPointerException {
        return Objects.requireNonNull(reference, "%s must not be null.".formatted(referenceName));
    }

    public static <T, E extends Exception> @NonNull T requireNonNullElseThrow(@Nullable T reference, Supplier<E> exceptionSupplier) throws E {
        if (reference == null) {
            throw (Exception)exceptionSupplier.get();
        }
        return reference;
    }
}

