/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class VarLengthOutputStream
implements Closeable {
    private final DataOutputStream out;

    public VarLengthOutputStream(OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    public void writeInt(int value) throws IOException {
        do {
            int bits = value & 0x7F;
            byte b = (byte)(bits + ((value >>>= 7) != 0 ? 128 : 0));
            this.out.write(b);
        } while (value != 0);
    }

    public void writeUTF(@Nullable String string) throws IOException {
        byte[] bytes = string == null ? "".getBytes(StandardCharsets.UTF_8) : string.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.out.write(bytes);
    }

    public void writeBoolean(boolean bool) throws IOException {
        this.out.write(bool ? 1 : 0);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

