/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class AuditUtils {
    public static List<UniformPath> getSubUniformPaths(IStorageInfo storageInfo, HistoryAccessOption historyOption, UniformPath uniformPath) throws StorageException {
        ProjectStorageSystem projectStorageSystem = storageInfo.getProjectStorageSystem();
        TokenElementIndex contentIndex = (TokenElementIndex)projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", historyOption);
        String path = uniformPath.toString();
        if (uniformPath.isArchitecturePath()) {
            Set sourcePaths = ArchitectureMetricsUtils.getArchitectureFreeSourcePaths((String)path, (ProjectStorageSystem)projectStorageSystem, (HistoryAccessOption)historyOption);
            return UniformPathCompatibilityUtil.convertCollection((Collection)contentIndex.getAllUniformPaths().stream().filter(sourcePaths::contains).collect(Collectors.toCollection(ArrayList::new)));
        }
        return UniformPathCompatibilityUtil.convertCollection((Collection)contentIndex.getUniformPathsStartingWith(path));
    }

    public static Optional<Integer> getFileMetricValueAsNumber(String uniformPath, MetricDirectoryIndex metricDirectoryIndex, MetricDirectorySchema schema, String key) throws StorageException {
        int metricIndex = schema.getValuePosition(key);
        if (metricIndex == -1) {
            return Optional.empty();
        }
        MetricDirectoryEntry entry = metricDirectoryIndex.getMetricDirectoryEntry(uniformPath);
        if (entry == null) {
            return Optional.empty();
        }
        Object metricValue = entry.getValueWithoutNullAssert(metricIndex);
        if (metricValue == null) {
            return Optional.empty();
        }
        if (!(metricValue instanceof Number)) {
            throw new IllegalStateException("Obtained metric value not a Number.");
        }
        Number value = (Number)metricValue;
        if (key.equals("Clone Coverage")) {
            return Optional.of((int)(value.doubleValue() * 100.0));
        }
        return Optional.of(value.intValue());
    }
}

