/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.service.audit.EAuditExportTable;
import com.teamscale.service.audit.EAuditMessageKey;
import com.teamscale.service.audit.LatexTableExportServiceBase;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/audit/latex-table")
public class LatexTableMultipleProjectsExportService
extends LatexTableExportServiceBase {
    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @Operation(summary="Export Latex metric table", description="Service for exporting Latex tables containing metrics for a given project as well as the corresponding test and application subprojects.", tags={"Audit"})
    public String getMultiProjectLatexTable(@BeanParam MultiLatexTableExportParameters parameters) throws StorageException {
        StringBuilder stringBuilder = new StringBuilder();
        for (EAuditExportTable metricName : parameters.metrics) {
            stringBuilder.append(this.getLatexTableForMultipleProjects(metricName, parameters));
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    private String getLatexTableForMultipleProjects(EAuditExportTable metricName, MultiLatexTableExportParameters parameters) throws StorageException {
        ProjectDataAccessor applicationProjectAccessor = this.createProjectDataAccessor(parameters.applicationProject, parameters.language.getMessage(EAuditMessageKey.APPLICATION_PROJECT), UniformPath.codeRoot());
        ProjectDataAccessor testProjectAccessor = this.createProjectDataAccessor(parameters.testProject, parameters.language.getMessage(EAuditMessageKey.TEST_PROJECT), UniformPath.codeRoot());
        ProjectDataAccessor allProjectAccessor = this.createProjectDataAccessor(parameters.allProject, parameters.language.getMessage(EAuditMessageKey.ALL_PROJECT), UniformPath.codeRoot());
        return LatexTableMultipleProjectsExportService.getLatexTable(metricName, parameters.language, allProjectAccessor, applicationProjectAccessor, testProjectAccessor);
    }

    private static class MultiLatexTableExportParameters
    extends LatexTableExportServiceBase.LatexTableExportParameters {
        @Parameter(description="The project with corresponding application code.", required=true)
        @QueryParam(value="application")
        private String applicationProject;
        @Parameter(description="The project with corresponding test code.", required=true)
        @QueryParam(value="test")
        private String testProject;
        @Parameter(description="The project with test and application code combined.", required=true)
        @QueryParam(value="all")
        private String allProject;

        private MultiLatexTableExportParameters() {
        }
    }
}

