/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class RepositoryLogIndexUtils {
    public static List<ExtendedRepositoryLogEntry> obtainEntriesOlder(int numberOfCommits, long endTimestamp, CommitDescriptor commit, RepositoryLogIndexQueryParameters queryParameters) throws StorageException {
        FilteredRepositoryLogEntriesCollector logEntriesCollector = new FilteredRepositoryLogEntriesCollector(numberOfCommits, endTimestamp, commit, queryParameters);
        return RepositoryLogIndexUtils.sortAndTruncateResult(logEntriesCollector.getLogEntries(), numberOfCommits, true);
    }

    public static List<ExtendedRepositoryLogEntry> obtainEntriesNewer(int numResults, long startTimestamp, CommitDescriptor historyOriginCommit, RepositoryLogIndexQueryParameters queryParameters) throws StorageException {
        List relevantCommits = queryParameters.commitDescriptorIndex.getCommitHistory(historyOriginCommit, startTimestamp);
        List<ExtendedRepositoryLogEntry> fullResult = queryParameters.repositoryLogFilter.filter(queryParameters.logEntryResolver.resolveRepositoryLogEntryAggregatesAsAggregatedEntries(queryParameters.index.getEntries(relevantCommits), null));
        return RepositoryLogIndexUtils.sortAndTruncateResult(fullResult, numResults, false);
    }

    public static List<ExtendedRepositoryLogEntry> obtainEntriesBetween(long startTimestamp, long endTimestamp, CommitDescriptor historyOriginCommit, RepositoryLogIndexQueryParameters queryParameters) throws StorageException {
        List commits = queryParameters.commitDescriptorIndex.getCommitHistory(historyOriginCommit, startTimestamp);
        commits.removeIf(commit -> commit.getTimestamp() >= endTimestamp);
        return RepositoryLogIndexUtils.sortAndTruncateResult(queryParameters.repositoryLogFilter.filter(queryParameters.logEntryResolver.resolveRepositoryLogEntryAggregatesAsAggregatedEntries(queryParameters.index.getEntries(commits), null)), Integer.MAX_VALUE, true);
    }

    private static List<ExtendedRepositoryLogEntry> sortAndTruncateResult(List<ExtendedRepositoryLogEntry> input, int numResults, boolean preserveNewer) {
        ArrayList result = CollectionUtils.sort(input);
        if (result.size() <= numResults) {
            return new ArrayList<ExtendedRepositoryLogEntry>(result);
        }
        if (preserveNewer) {
            return result.subList(result.size() - numResults, result.size());
        }
        return result.subList(0, numResults);
    }

    private static class FilteredRepositoryLogEntriesCollector {
        private static final int MAX_INITIAL_RESULT_ARRAY_SIZE = 1000;
        private final RepositoryLogIndex repositoryLogIndex;
        private final RepositoryLogFilter repositoryLogFilter;
        private final List<ParentedCommitDescriptor> openCommits;
        private final List<ExtendedRepositoryLogEntry> result;
        private final CommitDescriptorIndex.CommitHistoryScanner commitHistoryScanner;
        private final long commitHistoryStart;
        private final int numberOfCommits;
        private final LogEntryResolver logEntryResolver;

        private FilteredRepositoryLogEntriesCollector(int numberOfCommits, long endTimestamp, CommitDescriptor commit, RepositoryLogIndexQueryParameters queryParameters) throws StorageException {
            this.repositoryLogIndex = queryParameters.index;
            this.logEntryResolver = queryParameters.logEntryResolver;
            this.repositoryLogFilter = queryParameters.repositoryLogFilter;
            this.openCommits = new ArrayList<ParentedCommitDescriptor>(Math.min(numberOfCommits, 1000));
            this.result = new ArrayList<ExtendedRepositoryLogEntry>(Math.min(numberOfCommits, 1000));
            this.numberOfCommits = numberOfCommits;
            this.commitHistoryStart = this.repositoryLogIndex.getOldestTimestamp();
            CommitDescriptor queriedCommit = commit;
            if (queriedCommit.isHeadCommit()) {
                long newestRepositoryTimestamp = this.repositoryLogIndex.getNewestTimestamp();
                if (newestRepositoryTimestamp == 0L) {
                    newestRepositoryTimestamp = System.currentTimeMillis();
                }
                queriedCommit = new CommitDescriptor(commit.getBranchName(), newestRepositoryTimestamp);
            }
            this.commitHistoryScanner = queryParameters.commitDescriptorIndex.getCommitHistoryCollector(queriedCommit);
            this.performInitialCommitHistoryScan(endTimestamp, queriedCommit);
        }

        private void performInitialCommitHistoryScan(long endTimestamp, CommitDescriptor commit) throws StorageException {
            long commitHistoryEnd = endTimestamp != -1L ? endTimestamp : commit.getTimestamp() + 1L;
            long initialRange = commit.getTimestamp() - commitHistoryEnd + 86400000L;
            this.commitHistoryScanner.scanTimeRange(initialRange, parentedCommit -> {
                if (parentedCommit.getTimestamp() < commitHistoryEnd) {
                    this.openCommits.add((ParentedCommitDescriptor)parentedCommit);
                }
            });
            this.addLogEntriesForCommits();
        }

        private void addLogEntriesForCommits() throws StorageException {
            if (this.openCommits.isEmpty()) {
                return;
            }
            List<ExtendedRepositoryLogEntry> extendedRepositoryLogEntries = this.logEntryResolver.resolveRepositoryLogEntryAggregatesAsAggregatedEntries(this.repositoryLogIndex.getEntries(this.openCommits), null);
            this.result.addAll(this.repositoryLogFilter.filter(extendedRepositoryLogEntries));
            this.openCommits.clear();
        }

        public List<ExtendedRepositoryLogEntry> getLogEntries() throws StorageException {
            long timeRange = 86400000L;
            while (!this.finishedCommitHistoryScan()) {
                while (!this.scannedSufficientCommitHistory()) {
                    this.commitHistoryScanner.scanTimeRange(timeRange *= 2L, this.openCommits::add);
                }
                this.addLogEntriesForCommits();
            }
            return this.result;
        }

        private boolean finishedCommitHistoryScan() {
            return this.result.size() >= this.numberOfCommits || this.commitHistoryScanner.getLowerTimestampBoundary() < this.commitHistoryStart;
        }

        private boolean scannedSufficientCommitHistory() {
            return this.openCommits.size() >= this.numberOfCommits - this.result.size() || this.finishedCommitHistoryScan();
        }
    }

    public static class RepositoryLogIndexQueryParameters {
        private final RepositoryLogIndex index;
        private final RepositoryLogFilter repositoryLogFilter;
        private final CommitDescriptorIndex commitDescriptorIndex;
        private final LogEntryResolver logEntryResolver;

        public RepositoryLogIndexQueryParameters(RepositoryLogIndex index, RepositoryLogFilter repositoryLogFilter, CommitDescriptorIndex commitDescriptorIndex, LogEntryResolver logEntryResolver) {
            this.index = index;
            this.repositoryLogFilter = repositoryLogFilter;
            this.commitDescriptorIndex = commitDescriptorIndex;
            this.logEntryResolver = logEntryResolver;
        }
    }
}

