/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.cpp.debug;

import com.google.common.math.Stats;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/cpp/debug/required-reparsing-statistics")
public class DebugCppRequiredReparsingStatisticsService
extends ApiBase {
    @GET
    @Operation(summary="Retrieve statistics on how many files were reparsed even though their contents did not change", description="", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String retrieveGeneralStatisticsOnProjectHistory(@QueryParam(value="startTimestamp") @Parameter(description="All data before this timestamp will be ignored. By default (if no value is given), we return data for 14 days before the current analysis head.", required=false) @DefaultValue(value="-1") long startTimestamp, @QueryParam(value="computeAnalysisOverhead") @Parameter(description="Whether this service also computes how many additional files have changes in their ASTs (i.e., for how many additional files we start the analysis pipeline). Computing this statistic can get quite expensive.", required=false) @DefaultValue(value="false") boolean computeAnalysisOverhead) throws StorageException {
        long resolvedStartTimestamp = startTimestamp;
        if (startTimestamp == -1L) {
            HistoryAccessOption resolvedHistoryAccessOption = this.getProjectStorageSystem().resolveHistoryAccessOptionCached(this.readDefaultBranchHead(), BasicTokenElementIndex.class, Optional.empty());
            resolvedStartTimestamp = resolvedHistoryAccessOption.getTimestamp() - Duration.ofDays(14L).toMillis();
        }
        List<CommitStatistic> commitStatistics = this.getStatisticsForCommitsNewerThan(resolvedStartTimestamp, computeAnalysisOverhead);
        StringBuilder stringBuilder = new StringBuilder("Statistics of files that were reparsed because of changes in other files\n");
        stringBuilder.append("Limited to ").append(commitStatistics.size()).append(" commits. All commits since ").append(resolvedStartTimestamp).append(" (").append(Date.from(Instant.ofEpochMilli(resolvedStartTimestamp))).append(")\n");
        DebugCppRequiredReparsingStatisticsService.appendRatioStatistics(commitStatistics, stringBuilder, computeAnalysisOverhead);
        DebugCppRequiredReparsingStatisticsService.appendAbsoluteValueStatistics(commitStatistics, stringBuilder);
        return stringBuilder.toString();
    }

    @GET
    @Path(value="commit-details")
    @Operation(summary="Retrieve information on a single commit", description="Returns which files must be reanalyzed in a given commit", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String retrieveFilesReparsedInCommit(@QueryParam(value="t") @Parameter(description="The commit about which this service call returns details.", required=true) UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor resolvedCommit = this.resolve(unresolvedCommit);
        ReparseRequiredIndex reparseRequiredIndex = this.openProjectIndex(ReparseRequiredIndex.class, null);
        List paths = reparseRequiredIndex.getAdditionalReparsingRequiredPaths(resolvedCommit);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Paths that need to be preprocessed/parsed again in commit ").append(resolvedCommit.toServiceCallFormat()).append(" because of changes in other files:\n");
        for (String path : paths) {
            stringBuilder.append(path).append("\n");
        }
        return stringBuilder.toString();
    }

    private @NonNull List<CommitStatistic> getStatisticsForCommitsNewerThan(long resolvedStartTimestamp, boolean computeAnalysisOverhead) throws StorageException {
        ArrayList<CommitStatistic> commitStatistics = new ArrayList<CommitStatistic>();
        ReparseRequiredIndex reparseRequiredIndex = this.openProjectIndex(ReparseRequiredIndex.class, null);
        CommitDescriptorIndex commitDescriptorIndex = this.openCommitDescriptorIndex();
        for (ParentedCommitDescriptor commit : commitDescriptorIndex.getAllCommits()) {
            if (commit.getTimestamp() < resolvedStartTimestamp) continue;
            List<String> changedFiles = this.determineFilesWithBasicTokenElementChanges(commit);
            List reparsingRequiredFiles = reparseRequiredIndex.getAdditionalReparsingRequiredPaths((CommitDescriptor)commit);
            List<Object> changedTokenElements = Collections.emptyList();
            if (computeAnalysisOverhead) {
                changedTokenElements = this.determineFilesWithTokenElementChanges(commit);
            }
            commitStatistics.add(new CommitStatistic((CommitDescriptor)commit, changedFiles.size(), reparsingRequiredFiles.size(), changedTokenElements.size()));
        }
        return commitStatistics;
    }

    private static void appendAbsoluteValueStatistics(List<CommitStatistic> commitStatistics, StringBuilder stringBuilder) {
        Stats forcedFilesAbsoluteStats = Stats.of((Iterable)CollectionUtils.map(commitStatistics, stat -> stat.numberOfFilesWithRequiredReparsing));
        stringBuilder.append("\n\nAbsolute number of unchanged files that were reparsed per commit\n");
        stringBuilder.append("max: ").append(forcedFilesAbsoluteStats.max()).append("\n");
        stringBuilder.append("mean: ").append(forcedFilesAbsoluteStats.mean()).append("\n");
        stringBuilder.append("min: ").append(forcedFilesAbsoluteStats.min()).append("\n");
    }

    private static void appendRatioStatistics(List<CommitStatistic> commitStatistics, StringBuilder stringBuilder, boolean computeAnalysisOverhead) {
        List parsingOverheadPercentages = CollectionUtils.map(commitStatistics, CommitStatistic::computeParsingOverheadPercentage);
        Stats parsingOverheadStatistics = Stats.of((Iterable)parsingOverheadPercentages);
        stringBuilder.append("\n\n\"(Files without text changes that are reparsed / all files that are reparsed) * 100\" evaluated by commit\n");
        stringBuilder.append("max: ").append(parsingOverheadStatistics.max()).append("\n");
        stringBuilder.append("mean: ").append(parsingOverheadStatistics.mean()).append("\n");
        stringBuilder.append("min: ").append(parsingOverheadStatistics.min()).append("\n");
        if (computeAnalysisOverhead) {
            List analysisOverheadPercentages = CollectionUtils.map(commitStatistics, CommitStatistic::computeAnalysisOverheadPercentage);
            Stats analysisOverheadStatistics = Stats.of((Iterable)analysisOverheadPercentages);
            stringBuilder.append("\n\n\"(Files without text changes that have TokenElementInfo changes / all files that have TokenElementInfo changes) * 100\" evaluated by commit\n");
            stringBuilder.append("max: ").append(analysisOverheadStatistics.max()).append("\n");
            stringBuilder.append("mean: ").append(analysisOverheadStatistics.mean()).append("\n");
            stringBuilder.append("min: ").append(analysisOverheadStatistics.min()).append("\n");
        }
    }

    private List<String> determineFilesWithBasicTokenElementChanges(ParentedCommitDescriptor commit) throws StorageException {
        BasicTokenElementIndex indexAtCommit = this.openProjectIndex(BasicTokenElementIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        CommitDescriptor parent = commit.getFirstParentCommit();
        if (parent == null) {
            return indexAtCommit.getAllUniformPaths();
        }
        BasicTokenElementIndex indexAtParent = this.openProjectIndex(BasicTokenElementIndex.class, HistoryAccessOption.readTimestamp((String)parent.getBranchName(), (long)parent.getTimestamp()));
        PairList currentEntries = indexAtCommit.getAllTokenElements();
        return DebugCppRequiredReparsingStatisticsService.determineAddedOrChangedPaths(currentEntries, indexAtParent.getTokenElementsByPath((Collection)currentEntries.extractFirstList()));
    }

    private List<String> determineFilesWithTokenElementChanges(ParentedCommitDescriptor commit) throws StorageException {
        TokenElementIndex indexAtCommit = this.openProjectIndex(TokenElementIndex.class, "content", HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        CommitDescriptor parent = commit.getFirstParentCommit();
        if (parent == null) {
            return indexAtCommit.getAllUniformPaths();
        }
        TokenElementIndex indexAtParent = this.openProjectIndex(TokenElementIndex.class, "content", HistoryAccessOption.readTimestamp((String)parent.getBranchName(), (long)parent.getTimestamp()));
        PairList currentEntries = indexAtCommit.getAllTokenElements();
        return DebugCppRequiredReparsingStatisticsService.determineAddedOrChangedPaths(currentEntries, indexAtParent.getTokenElementsByUniformPath((Collection)currentEntries.extractFirstList()));
    }

    private static <T extends Serializable> List<String> determineAddedOrChangedPaths(PairList<String, T> currentEntries, Map<String, T> parentEntries) throws StorageException {
        ArrayList<String> addedOrChangedKeys = new ArrayList<String>();
        for (Pair entry : currentEntries) {
            byte[] parentValue;
            byte[] currentValue;
            if (!parentEntries.containsKey(entry.getFirst())) {
                addedOrChangedKeys.add((String)entry.getFirst());
                continue;
            }
            if (entry.getSecond() instanceof BasicTokenElementInfo && ((BasicTokenElementInfo)entry.getSecond()).getFirstDetailOfType(HiddenTokenElementDetail.class).isPresent() || Arrays.equals(currentValue = StorageUtils.serialize((Serializable)((Serializable)entry.getSecond())), parentValue = StorageUtils.serialize((Serializable)((Serializable)parentEntries.get(entry.getFirst()))))) continue;
            addedOrChangedKeys.add((String)entry.getFirst());
        }
        return addedOrChangedKeys;
    }

    private static final class CommitStatistic {
        private final CommitDescriptor commit;
        private final int numberOfFilesWithContentChange;
        private final int numberOfFilesWithRequiredReparsing;
        private final int numberOfFilesWithTokenElementChange;

        private CommitStatistic(CommitDescriptor commit, int numberOfFilesWithContentChange, int numberOfFilesWithRequiredReparsing, int numberOfFilesWithTokenElementChange) {
            this.commit = commit;
            this.numberOfFilesWithContentChange = numberOfFilesWithContentChange;
            this.numberOfFilesWithRequiredReparsing = numberOfFilesWithRequiredReparsing;
            this.numberOfFilesWithTokenElementChange = numberOfFilesWithTokenElementChange;
        }

        private double computeParsingOverheadPercentage() {
            if (this.numberOfFilesWithContentChange == 0) {
                return 0.0;
            }
            return 100.0 * (double)this.numberOfFilesWithRequiredReparsing / (double)(this.numberOfFilesWithRequiredReparsing + this.numberOfFilesWithContentChange);
        }

        private double computeAnalysisOverheadPercentage() {
            if (this.numberOfFilesWithTokenElementChange == 0) {
                return 0.0;
            }
            int numberOfAdditionalAnalyzedFiles = this.numberOfFilesWithTokenElementChange - this.numberOfFilesWithContentChange;
            return 100.0 * (double)numberOfAdditionalAnalyzedFiles / (double)this.numberOfFilesWithTokenElementChange;
        }
    }
}

