/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.user.UserRecentlyViewedProjectsIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public class PerspectiveContextUtils {
    private static final int MAX_RECENT_PROJECTS = 5;

    public static List<ProjectInfo> getRecentProjectsForUser(ITeamscaleServiceInfo serviceInfo, List<ProjectInfo> visibleProjects) throws StorageException {
        ProjectIndex projectIndex = serviceInfo.getIndexLayer().openProjectIndex();
        List recentProjects = ((UserRecentlyViewedProjectsIndex)serviceInfo.getIndexLayer().openGlobalIndex(UserRecentlyViewedProjectsIndex.class)).getRecentProjectIds(serviceInfo.getUser().getUsername());
        ArrayList recentProjectIds = new ArrayList();
        for (PublicProjectId publicProjectId : recentProjects) {
            Optional internalProjectId = projectIndex.tryResolveToInternalId((IProjectId)publicProjectId);
            internalProjectId.ifPresent(recentProjectIds::add);
        }
        Map projectIdToProjectInfoMap = visibleProjects.stream().collect(Collectors.toMap(ProjectInfo::getInternalId, Function.identity()));
        return recentProjectIds.stream().filter(projectIdToProjectInfoMap::containsKey).distinct().map(projectIdToProjectInfoMap::get).limit(5L).collect(Collectors.toList());
    }
}

