/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.options.DataPrivacyOption;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.CodeFindingsRetriever;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FilteredFindingDelta;
import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.index.findings.calculation.FindingDeltaFilterUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.findings.DeltaAnalysisServiceBase;
import com.teamscale.service.findings.ExcludedFindingsUtils;
import com.teamscale.service.findings.ExtendedFindingDeltaWithExcludedFindings;
import com.teamscale.service.findings.badge.FindingBadgeCreator;
import com.teamscale.service.framework.authentication.Badge;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/findings/delta")
public class FindingDeltaService
extends DeltaAnalysisServiceBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Operation(summary="Get finding delta", description="Retrieves the finding delta (i.e., the list of newly added and deleted findings) for the given uniform path and time range.", tags={"Findings", "Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ExtendedFindingDeltaWithExcludedFindings getFindingDelta(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters, @BeanParam BasicFindingsFilterSettings filterSettings, @Parameter(description="Filter findings changed by commits of this user group. The group needs at least 3 members.") @QueryParam(value="group") String userGroupName) throws StorageException {
        FilteredFindingDelta findingDelta = this.calculateFindingDelta(timeRangeParameters, filterSettings, false, userGroupName);
        FindingsCalculationInfo calculationInfo = this.getFindingsCalculationInfo();
        ExcludedFindingsUtils.ExcludedFindingsDelta excludedFindingsDelta = ExcludedFindingsUtils.getExcludedFindingsDelta(null, timeRangeParameters.getUniformPath(), this.createTimeRange(timeRangeParameters), filterSettings, this.resourceContext, calculationInfo);
        return ExtendedFindingDeltaWithExcludedFindings.create(findingDelta, excludedFindingsDelta, calculationInfo);
    }

    @GET
    @Path(value="count")
    @Operation(summary="Get finding delta", description="Retrieves the finding delta (i.e., the list of newly added and deleted findings) for the given uniform path and time range.", tags={"Findings", "Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public FindingDeltaCount getFindingDeltaCount(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters, @BeanParam BasicFindingsFilterSettings filterSettings, @Parameter(description="Filter findings changed by commits of this user group. The group needs at least 3 members.") @QueryParam(value="group") String userGroupName) throws StorageException {
        if (userGroupName != null && DataPrivacyOption.getDataPrivacyOption((GlobalStorageSystem)this.getGlobalStorageSystem()).limitDevelopersLogToOwnCommits) {
            throw new ForbiddenException("Privacy option is enabled.");
        }
        FilteredFindingDelta findingDelta = this.calculateFindingDelta(timeRangeParameters, filterSettings, true, userGroupName);
        return FindingDeltaCount.create((FilteredFindingDelta)findingDelta);
    }

    @GET
    @Badge
    @Path(value="badge")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Get finding delta badge", description="Creates a badge for the finding delta, i.e. for the count of newly added, unmodified, and deleted findings.", tags={"Findings", "Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"image/svg+xml"})
    public byte[] getFindingDeltaBadge(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters, @BeanParam BasicFindingsFilterSettings filterSettings, @Parameter(description="Filter findings changed by commits of this user group. The group needs at least 3 members.") @QueryParam(value="group") @Nullable String userGroupName) throws StorageException {
        FilteredFindingDelta findingDelta = this.calculateFindingDelta(timeRangeParameters, filterSettings, true, userGroupName);
        return StringUtils.stringToBytes((String)new FindingBadgeCreator(FindingDeltaCount.create((FilteredFindingDelta)findingDelta), false).createBadge());
    }

    private FilteredFindingDelta calculateFindingDelta(TimeRangeResourceServiceQueryOptions timeRangeParameters, BasicFindingsFilterSettings filterSettings, boolean numericDeltaOnly, String userGroupName) throws StorageException {
        Optional<UserGroup> userGroup = this.getValidatedUserGroup(userGroupName);
        FindingsCalculationInfo calculationInfo = this.getFindingsCalculationInfo();
        TimeRange range = this.createTimeRange(timeRangeParameters);
        if (userGroup.isEmpty()) {
            return FindingDeltaFilterUtils.calculateFindingDeltaForPath((CommitDescriptor)range.start(), (CommitDescriptor)range.end(), (BasicFindingsFilterSettings)filterSettings, (boolean)numericDeltaOnly, (String)timeRangeParameters.getUniformPath().toString(), (FindingsCalculationInfo)calculationInfo);
        }
        return this.calculateFindingDeltaForGroup(range, filterSettings, timeRangeParameters.getUniformPath().toString(), userGroup.get(), calculationInfo);
    }

    private @NonNull FindingsCalculationInfo getFindingsCalculationInfo() {
        return new FindingsCalculationInfo(this.serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.serviceInfo.getProjectStorageSystem(), this.serviceInfo.getIndexLayer());
    }

    private FilteredFindingDelta calculateFindingDeltaForGroup(TimeRange range, BasicFindingsFilterSettings filterSettings, String uniformPath, UserGroup userGroup, FindingsCalculationInfo calculationInfo) throws StorageException {
        Set<UserFullNameAndAliases> groupMembers;
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        FindingChurnList findingChurnList = this.calculateFindingChurnList(uniformPath, range, repositoryLogIndex, groupMembers = this.getGroupMembers(userGroup));
        if (findingChurnList == null) {
            return new FilteredFindingDelta(FilteredFindingsList.EMPTY, FilteredFindingsList.EMPTY, FilteredFindingsList.EMPTY);
        }
        CodeFindingsRetriever findingsRetriever = new CodeFindingsRetriever((ProjectStorageSystem)this.getProjectStorageSystem());
        FindingDelta findingDelta = FindingDelta.create((Collection)findingChurnList.getAddedFindings(), (Collection)findingChurnList.getFindingsInChangedCode(), (Collection)findingChurnList.getRemovedFindings());
        return ExtendedTrackedFindingUtils.fromFindingDelta((FindingDelta)findingDelta, (FindingsCalculationInfo)calculationInfo, (IFindingsRetriever)findingsRetriever, (CommitDescriptor[])new CommitDescriptor[]{range.end()}).applyFilter(filterSettings, calculationInfo);
    }

    private @NonNull Set<UserFullNameAndAliases> getGroupMembers(UserGroup userGroup) throws StorageException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        return CollectionUtils.mapWithException((Collection)userGroup.getUserNames(), arg_0 -> ((UserIndex)userIndex).getUser(arg_0)).stream().map(user -> new UserFullNameAndAliases(user.getFullName(), (Set<String>)user.getAliases())).collect(Collectors.toSet());
    }

    private @Nullable FindingChurnList calculateFindingChurnList(String uniformPath, TimeRange range, RepositoryLogIndex repositoryLogIndex, Set<UserFullNameAndAliases> groupMembers) throws StorageException {
        List relevantCommits = this.getRelevantCommits(range.start(), range.end(), uniformPath, false);
        relevantCommits = CollectionUtils.filterWithException(relevantCommits, commitDescriptor -> FindingDeltaService.isCommitAuthoredByGroupMember(commitDescriptor, repositoryLogIndex, groupMembers));
        return FindingsServiceUtils.getFindingChurnListForCommits((List)relevantCommits, (FindingChurnListIndex)this.openProjectIndex(FindingChurnListIndex.class, null));
    }

    private static boolean isCommitAuthoredByGroupMember(CommitDescriptor commitDescriptor, RepositoryLogIndex repositoryLogIndex, Set<UserFullNameAndAliases> groupMembers) throws StorageException {
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(commitDescriptor);
        if (logEntry == null) {
            return false;
        }
        return FindingDeltaService.isMemberOfGroup(groupMembers, logEntry.getAuthor());
    }

    private static boolean isMemberOfGroup(Set<UserFullNameAndAliases> groupMembers, String findingCommitAuthor) {
        for (UserFullNameAndAliases member : groupMembers) {
            if (member.fullName.equals(findingCommitAuthor)) {
                return true;
            }
            if (!member.aliases.contains(findingCommitAuthor)) continue;
            return true;
        }
        return false;
    }

    private record UserFullNameAndAliases(String fullName, Set<String> aliases) {
    }
}

