/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.FindingsPaginationOptions;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.service.findings.ElementFindingsServiceBase;
import com.teamscale.service.findings.IElementFindingsServiceApi;
import com.teamscale.service.findings.PaginatedFindingsWithCount;
import com.teamscale.service.findings.options.FindingsExportRequestOptions;
import com.teamscale.service.findings.options.FindingsRequestOptions;
import com.teamscale.wia.SpecItem;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ITeamscaleIssueFindingLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/findings/list")
public class FindingsListService
extends ElementFindingsServiceBase
implements IElementFindingsServiceApi {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public List<ExtendedTrackedFinding> getFindings(FindingsRequestOptions requestOptions) throws StorageException {
        return super.retrieveFilteredFindingsWithSortingAndPagination(requestOptions.getUniformPath(), requestOptions.isCaseInsensitivePath(), requestOptions.getFindingsFilterSettings(), requestOptions.getSortOptions(), requestOptions.getPaginationOptions()).findings();
    }

    @Override
    public List<@Nullable TrackedFinding> getFindingsWithIds(List<String> findingIds, UnresolvedCommitDescriptor unresolvedCommit, boolean specItemsOnly) throws StorageException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getIndexLayer());
        IFindingsRetriever findingsRetriever = IFindingsRetriever.getFindingsRetriever((boolean)specItemsOnly, (boolean)false, (String)commit.getBranchName(), (FindingsCalculationInfo)calculationInfo);
        return findingsRetriever.getFindings(findingIds, commit);
    }

    @Override
    public PaginatedFindingsWithCount getFindingsWithCount(FindingsRequestOptions requestOptions) throws StorageException {
        UniformPath uniformPath = requestOptions.getUniformPath();
        FindingsFilterSettings findingsFilterSettings = requestOptions.getFindingsFilterSettings();
        FilteredFindingsList filteredFindings = this.retrieveFilteredFindings(uniformPath, findingsFilterSettings);
        List allFindings = filteredFindings.filteredFindings();
        List<ExtendedTrackedFinding> adjustedFindings = FindingsListService.applySortingAndPagination(allFindings, requestOptions.getSortOptions(), requestOptions.getPaginationOptions());
        adjustedFindings = this.updateDeathCommitsAndAdjustLocations(adjustedFindings, findingsFilterSettings.getCommit());
        return PaginatedFindingsWithCount.from(filteredFindings.excludedFindingsCount(), allFindings, adjustedFindings, this.getReferencedSpecItemsById(adjustedFindings), requestOptions.getPaginationOptions().getNextStartIndex());
    }

    private Map<String, SpecItem> getReferencedSpecItemsById(List<ExtendedTrackedFinding> findings) {
        SetMap issueIdsByBirthCommits = new SetMap();
        for (ExtendedTrackedFinding extendedTrackedFinding : findings) {
            ElementLocation elementLocation = extendedTrackedFinding.getLocation();
            if (!(elementLocation instanceof ITeamscaleIssueFindingLocation)) continue;
            ITeamscaleIssueFindingLocation issueLocation = (ITeamscaleIssueFindingLocation)elementLocation;
            issueIdsByBirthCommits.add((Object)extendedTrackedFinding.getBirthCommit().toUnresolvedCommitDescriptor(), (Object)issueLocation.getIssueId());
        }
        HashMap<String, SpecItem> specItemsById = new HashMap<String, SpecItem>();
        try {
            for (Map.Entry entry : issueIdsByBirthCommits.entrySet()) {
                SpecItemIndex specItemIndex = this.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readTimestamp((String)((UnresolvedCommitDescriptor)entry.getKey()).getBranchName(), (long)((UnresolvedCommitDescriptor)entry.getKey()).getTimestamp()));
                for (SpecItem specItem : CollectionUtils.filterNullEntries((Collection)specItemIndex.getIssuesForInternalIds(((Set)entry.getValue()).stream().toList()))) {
                    specItemsById.put(specItem.getIdAsString(), specItem);
                }
            }
        }
        catch (StorageException storageException) {
            LOGGER.error("Error loading spec items for findings, result may be incomplete", (Throwable)storageException);
        }
        return specItemsById;
    }

    @Override
    public Response getFindingsExport(FindingsExportRequestOptions requestOptions) throws StorageException {
        FindingsFilterSettings findingsFilterSettings = requestOptions.getFindingsFilterSettings();
        List findings = super.retrieveFilteredFindingsWithSortingAndPagination(requestOptions.getUniformPath(), false, findingsFilterSettings, requestOptions.getSortOptions(), FindingsPaginationOptions.all()).findings();
        return FindingsListService.createFindingsExportDownload(requestOptions.getExportFormat(), findings, this.serviceInfo.getRequestBaseUri(), this.serviceInfo.getPrimaryPublicId(), this.resolve(findingsFilterSettings.getCommit()));
    }
}

