/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.clangtidy.debug;

import com.google.common.hash.HashCode;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisHashUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisRequestParameters;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyResultsTransport;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.EClangTidyOutsourcedAnalysisStatus;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisContext;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisContextIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisFindingsCacheIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server.ClangTidyOutsourcedAnalysisStatusIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/findings/clang-tidy/debug/execution-server")
public class ClangTidyExecutionServerDebugService
extends ApiBase {
    public static final Comparator<ClangTidyResultsTransport.ClangTidyFindingTransport> FINDING_COMPARATOR = Comparator.comparing(ClangTidyResultsTransport.ClangTidyFindingTransport::location, Comparator.comparing(TextRegionLocation::getRawStartLine)).thenComparing(ClangTidyResultsTransport.ClangTidyFindingTransport::message);

    @GET
    @Path(value="sessions-list")
    @Operation(summary="Lists the clang-tidy analysis sessions known on this execution server", description="", tags={"Source Code"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String printSessionStatus() throws StorageException, IOException {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ClangTidyOutsourcedAnalysisStatusIndex analysisStatusIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisStatusIndex.class);
        ClangTidyOutsourcedAnalysisContextIndex contextIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisContextIndex.class);
        ClangTidyOutsourcedAnalysisFindingsCacheIndex findingsCacheIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisFindingsCacheIndex.class);
        PairList allStoredSessions = analysisStatusIndex.getAllStoredSessions();
        for (Pair sessionStatusIndexEntry : allStoredSessions) {
            String sessionKey = (String)sessionStatusIndexEntry.getFirst();
            Optional context = contextIndex.getContext(sessionKey);
            EClangTidyOutsourcedAnalysisStatus sessionStatus = (EClangTidyOutsourcedAnalysisStatus)sessionStatusIndexEntry.getSecond();
            String projectId = "?";
            String numAnalyzedFiles = "?";
            String numFindingsString = "?";
            String numParseLogsString = "?";
            String commit = "?";
            if (context.isPresent()) {
                projectId = ((ClangTidyOutsourcedAnalysisContext)context.get()).projectId().toString();
                numAnalyzedFiles = String.valueOf(((ClangTidyOutsourcedAnalysisContext)context.get()).parameters().analysisSubjectInfos().size());
                Map<String, ClangTidyResultsTransport> clangTidyResultsTransportMap = ClangTidyExecutionServerDebugService.loadAnalysisResults((ClangTidyOutsourcedAnalysisContext)context.get(), findingsCacheIndex);
                int numFindings = 0;
                int numParseLogs = 0;
                for (ClangTidyResultsTransport resultsTransport : clangTidyResultsTransportMap.values()) {
                    numFindings += resultsTransport.findings().size();
                    numParseLogs += resultsTransport.parseLogEntries().size();
                }
                numFindingsString = String.valueOf(numFindings);
                numParseLogsString = String.valueOf(numParseLogs);
                commit = ((ClangTidyOutsourcedAnalysisContext)context.get()).commit().toString();
            }
            String sessionStatusString = Optional.ofNullable(sessionStatus).map(Enum::name).orElse("no status stored");
            rows.add(this.createRow(sessionKey, sessionStatusString, projectId, commit, numAnalyzedFiles, numFindingsString, numParseLogsString));
        }
        List<String> headerRow = List.of("Session", "Status", "Project", "Commit", "#analyzedFiles", "#findings", "#parseLogEntries");
        return ClangTidyExecutionServerDebugService.printAsTable(rows, headerRow).toString();
    }

    private static Map<String, ClangTidyResultsTransport> loadAnalysisResults(ClangTidyOutsourcedAnalysisContext context, ClangTidyOutsourcedAnalysisFindingsCacheIndex findingsCacheIndex) throws StorageException {
        try {
            Map fileAnalysisHashes = CollectionUtils.map((Map)ClangTidyOutsourcedAnalysisHashUtils.computeInputHashCodesForSubjectFiles((ClangTidyOutsourcedAnalysisRequestParameters)context.parameters()), Function.identity(), HashCode::toString);
            return findingsCacheIndex.readCache(fileAnalysisHashes.values());
        }
        catch (RuntimeException e) {
            return Collections.emptyMap();
        }
    }

    @GET
    @Path(value="input-hashes-in-session")
    @Operation(summary="Lists the results of a given session on the execution server", description="To query all analysis results for a session, use a GET query to the api/analysis/clangtidy-execution service.", tags={"Source Code"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String printSessionDetails(@QueryParam(value="session-key") String sessionKey) throws StorageException {
        ClangTidyOutsourcedAnalysisContextIndex contextIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisContextIndex.class);
        Optional context = contextIndex.getContext(sessionKey);
        if (context.isEmpty()) {
            return "No session context with session id " + sessionKey + " stored in ClangTidyOutsourcedAnalysisContextIndex";
        }
        StringBuilder result = new StringBuilder();
        result.append("project ").append(((ClangTidyOutsourcedAnalysisContext)context.get()).projectId().toString()).append("\n");
        result.append("commit ").append(((ClangTidyOutsourcedAnalysisContext)context.get()).commit()).append("\n");
        result.append("session ").append(sessionKey).append("\n");
        String numAnalyzedFiles = String.valueOf(((ClangTidyOutsourcedAnalysisContext)context.get()).parameters().analysisSubjectInfos().size());
        result.append("analyzed files: ").append(numAnalyzedFiles).append("\n");
        ClangTidyOutsourcedAnalysisFindingsCacheIndex findingsCacheIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisFindingsCacheIndex.class);
        Map<String, ClangTidyResultsTransport> clangTidyResultsTransportMap = ClangTidyExecutionServerDebugService.loadAnalysisResults((ClangTidyOutsourcedAnalysisContext)context.get(), findingsCacheIndex);
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (Map.Entry entry2 : CollectionUtils.sort(clangTidyResultsTransportMap.entrySet(), Comparator.comparing(entry -> ((ClangTidyResultsTransport)entry.getValue()).uniformPath()))) {
            String inputHash = (String)entry2.getKey();
            ClangTidyResultsTransport resultsTransport = (ClangTidyResultsTransport)entry2.getValue();
            String uniformPath = resultsTransport.uniformPath();
            int numFindings = resultsTransport.findings().size();
            int numParseLogEntries = resultsTransport.parseLogEntries().size();
            rows.add(this.createRow(uniformPath, inputHash, String.valueOf(numFindings), String.valueOf(numParseLogEntries)));
        }
        List<String> headerRow = List.of("UniformPath", "inputHash", "#findings", "#parseLogEntries");
        result.append((CharSequence)ClangTidyExecutionServerDebugService.printAsTable(rows, headerRow));
        return result.toString();
    }

    @GET
    @Path(value="input-hash-results")
    @Operation(summary="Lists the results for a given input hash on the execution server", description="To query all analysis results for a session, use a GET query to the api/analysis/clangtidy-execution service.", tags={"Source Code"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String printInputHashResults(@QueryParam(value="input-hash") String inputHash) throws StorageException {
        ClangTidyOutsourcedAnalysisFindingsCacheIndex findingsCacheIndex = this.openGlobalIndex(ClangTidyOutsourcedAnalysisFindingsCacheIndex.class);
        Map clangTidyResultsTransportMap = findingsCacheIndex.readCache(Collections.singleton(inputHash));
        if (clangTidyResultsTransportMap.isEmpty()) {
            return "There is no result stored for input hash " + inputHash;
        }
        ClangTidyResultsTransport resultTransport = (ClangTidyResultsTransport)CollectionUtils.getAny(clangTidyResultsTransportMap.values());
        StringBuilder result = new StringBuilder();
        result.append("input hash ").append(inputHash).append("\n");
        result.append("uniform path ").append(resultTransport.uniformPath()).append("\n");
        result.append("\n").append("Findings").append("\n");
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (ClangTidyResultsTransport.ClangTidyFindingTransport finding : CollectionUtils.sort((Collection)resultTransport.findings(), FINDING_COMPARATOR)) {
            rows.add(this.createRow(finding.message(), finding.location().toLocationString(), finding.categoryName(), finding.groupName()));
        }
        List<String> headerRow = List.of("Finding Message", "Location", "Category", "Group");
        result.append((CharSequence)ClangTidyExecutionServerDebugService.printAsTable(rows, headerRow));
        result.append("\n").append("Parse Log Entries").append("\n");
        rows = new ArrayList();
        for (ParseLogMessage parseLogEntry : CollectionUtils.sort((Collection)resultTransport.parseLogEntries(), Comparator.comparing(ParseLogMessage::getLineNumber).thenComparing(ParseLogMessage::getFormattedMessage))) {
            rows.add(this.createRow(String.valueOf(parseLogEntry.getLineNumber()), parseLogEntry.getFormattedMessage()));
        }
        headerRow = List.of("Line Number", "Message");
        result.append((CharSequence)ClangTidyExecutionServerDebugService.printAsTable(rows, headerRow));
        return result.toString();
    }

    private List<String> createRow(String ... cells) {
        return Arrays.asList(cells);
    }

    private static StringBuilder printAsTable(List<List<String>> contentRows, List<String> headerRow) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (int i = 0; i < headerRow.size(); ++i) {
            int maxLength = headerRow.get(i).length();
            for (List<String> row : contentRows) {
                maxLength = Math.max(maxLength, row.get(i).length());
            }
            columnWidths.add(maxLength);
        }
        StringBuilder table = new StringBuilder();
        ClangTidyExecutionServerDebugService.appendRowToTable(headerRow, table, columnWidths);
        ClangTidyExecutionServerDebugService.appendSeparatorLineToTable(table, columnWidths);
        for (List<String> row : contentRows) {
            ClangTidyExecutionServerDebugService.appendRowToTable(row, table, columnWidths);
        }
        return table;
    }

    private static void appendRowToTable(List<String> row, StringBuilder table, List<Integer> columnWidths) {
        for (int i = 0; i < row.size(); ++i) {
            if (i == 0) {
                table.append("| ");
            } else {
                table.append(" | ");
            }
            String cellContent = row.get(i);
            table.append(cellContent);
            table.append(StringUtils.repeat((String)" ", (int)(columnWidths.get(i) - cellContent.length())));
            if (i != row.size() - 1) continue;
            table.append(" |");
        }
        table.append("\n");
    }

    private static void appendSeparatorLineToTable(StringBuilder table, List<Integer> columnWidths) {
        for (int i = 0; i < columnWidths.size(); ++i) {
            if (i == 0) {
                table.append("|-");
            } else {
                table.append("-|-");
            }
            table.append(StringUtils.repeat((String)"-", (int)columnWidths.get(i)));
            if (i != columnWidths.size() - 1) continue;
            table.append("-|");
        }
        table.append("\n");
    }
}

