/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class TrackedFindingUtils {
    public static int getStartLine(TrackedFinding finding) {
        TextRegionLocation findingTextRegionLocation = (TextRegionLocation)CCSMAssert.checkedCast((Object)finding.getLocation(), TextRegionLocation.class);
        return findingTextRegionLocation.getRawStartLine();
    }

    public static int getEndLine(TrackedFinding finding) {
        TextRegionLocation findingTextRegionLocation = (TextRegionLocation)CCSMAssert.checkedCast((Object)finding.getLocation(), TextRegionLocation.class);
        return findingTextRegionLocation.getRawEndLine();
    }

    public static ControlFlowGraph getControlFlowGraphOfMethodFromFinding(List<ControlFlowGraph> controlFlowGraphs, TrackedFinding finding) throws ConQATException {
        int findingStartLine = TrackedFindingUtils.getStartLine(finding);
        int findingEndLine = TrackedFindingUtils.getEndLine(finding);
        for (ControlFlowGraph controlFlowGraph : controlFlowGraphs) {
            List listOfMethods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)controlFlowGraph.getEntities(), (EShallowEntityType)EShallowEntityType.METHOD);
            CCSMAssert.isFalse((boolean)listOfMethods.isEmpty(), (String)"Expected control flow graph to cover at least one ShallowEntity of EShallowEntityType.METHOD");
            ShallowEntity methodEntity = (ShallowEntity)listOfMethods.get(0);
            int methodStartLine = methodEntity.getStartLine();
            int methodEndLine = methodEntity.getEndLine();
            if (methodStartLine > findingStartLine || methodEndLine < findingEndLine) continue;
            return controlFlowGraph;
        }
        throw new ConQATException("Could not find a control flow graph in " + controlFlowGraphs.toString() + "that covers finding " + finding.toString());
    }
}

