/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.github.debug;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubCheckRunMaintenanceTrigger;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/github/debug/check-runs")
public class DebugGitHubTeamscaleCheckRunService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Cancels in-progress check runs", description="Cancels all check runs for the given Git refs which were posted by Teamscale and are still in progress. This does *not* cancel any ongoing pull request analyses but only concludes the preliminary check run.", tags={"Debugging", "Merge Requests", "Voting Connectors"})
    @Path(value="cancel")
    public Response cancelTeamscaleInProgressCheckRuns(@Parameter(description="The repository name consisting of the owner and the repository separated by a slash.", required=true) @QueryParam(value="repository") String repositoryName, @Parameter(description="The Git refs whose check runs should be cancelled. Can be a commit SHA, branch name (heads/\\<branch name\\>) or tag (tags/\\<tag name\\>).", required=true) @QueryParam(value="refs") List<String> gitRefs) throws StorageException, ServiceCallException, ProjectConfigurationException {
        PlatformRepositoryIdentifier repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName((String)repositoryName, BadRequestException::new);
        GitHubPullRequestClient client = this.createGitHubClient(this.getIndexLayer(), this.getGlobalStorageSystem(), repositoryIdentifier, (IProjectId)this.serviceInfo.getInternalId());
        for (String ref : gitRefs) {
            DebugGitHubTeamscaleCheckRunService.cancelTeamscaleInProgressCheckRuns(repositoryIdentifier, ref, client);
        }
        return Response.ok().build();
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Cancels all in-progress check runs for a project", description="Cancels all check runs for a project which were posted by Teamscale and are still in progress. This does *not* cancel any ongoing pull request analyses but only concludes the preliminary check run. Teamscale will open new check runs if required.", tags={"Debugging", "Merge Requests", "Voting Connectors"})
    @Path(value="cancel-all")
    public Response cancelAllTeamscaleInProgressCheckRunsForProject() throws StorageException, ProjectConfigurationException, InterruptedException {
        GitHubCheckRunMaintenanceTrigger.closeCheckRunsInProject((IndexLayer)this.getIndexLayer(), (InternalProjectId)this.serviceInfo.getInternalId(), checkRun -> false, () -> false);
        return Response.ok().build();
    }

    private static void cancelTeamscaleInProgressCheckRuns(PlatformRepositoryIdentifier repositoryIdentifier, String ref, GitHubPullRequestClient client) throws ServiceCallException {
        List<CheckRun> pendingTeamscaleCheckRuns = DebugGitHubTeamscaleCheckRunService.fetchPendingTeamscaleCheckRunsForGitRef(repositoryIdentifier, ref, client);
        for (CheckRun checkRun : pendingTeamscaleCheckRuns) {
            DebugGitHubTeamscaleCheckRunService.closeSingleCheckRun(client, repositoryIdentifier, checkRun);
        }
    }

    private static void closeSingleCheckRun(GitHubPullRequestClient client, PlatformRepositoryIdentifier repositoryId, CheckRun checkRun) throws ServiceCallException {
        CheckRun updatedCheckRun = CheckRun.builder((CheckRun)checkRun).withConclusion(CheckRun.Conclusion.SKIPPED).withOutputTitle("Manually stopped.").build();
        client.updateCheckRun(repositoryId, checkRun.id().longValue(), updatedCheckRun);
    }

    private static List<CheckRun> fetchPendingTeamscaleCheckRunsForGitRef(PlatformRepositoryIdentifier repositoryId, String ref, GitHubPullRequestClient client) throws ServiceCallException {
        return client.getCheckRuns(repositoryId, ref, "in_progress").stream().filter(DebugGitHubTeamscaleCheckRunService::isTeamscaleCheckRun).toList();
    }

    private static boolean isTeamscaleCheckRun(CheckRun checkRun) {
        return checkRun.output().title().startsWith("Teamscale ") || checkRun.name().startsWith("Teamscale");
    }

    private GitHubPullRequestClient createGitHubClient(IndexLayer indexLayer, GlobalStorageSystem globalStorage, PlatformRepositoryIdentifier repositoryIdentifier, IProjectId projectId) throws StorageException, ProjectConfigurationException, ServiceCallException {
        GitHubRepositoryConnectorDescriptor githubConnectorDescriptor = this.guessConnectorForRepository(indexLayer, globalStorage, repositoryIdentifier, projectId);
        return new GitHubAppBasedRepositoryAccessHelper(githubConnectorDescriptor.getGitHubServerUrl().url(), repositoryIdentifier.asRepositoryName(), globalStorage, StorageException::new, LOGGER).createGitHubPullRequestClient();
    }

    private GitHubRepositoryConnectorDescriptor guessConnectorForRepository(IndexLayer indexLayer, GlobalStorageSystem globalStorage, PlatformRepositoryIdentifier repositoryIdentifier, IProjectId projectId) throws StorageException, ProjectConfigurationException {
        Optional connectorConfiguration = MergeRequestUtils.guessConnectorFromProject((IndexLayer)indexLayer, (IProjectId)projectId, (String)repositoryIdentifier.asRepositoryName(), List.of(configuration -> ConnectorUtils.tryCreateConnectorDescriptor((ConnectorConfiguration)configuration).filter(descriptor -> descriptor instanceof GitHubRepositoryConnectorDescriptor).isPresent()));
        if (connectorConfiguration.isEmpty()) {
            throw new BadRequestException("Could not find GitHub connector for the given repository name.");
        }
        return (GitHubRepositoryConnectorDescriptor)ConnectorUtils.loadConnector((ConnectorConfiguration)((ConnectorConfiguration)connectorConfiguration.get()), (ConfigurationInitializationContext)new ConfigurationInitializationContext(indexLayer, (IExternalCredentialsProvider)globalStorage.openGlobalIndex(ExternalCredentialsIndex.class)), (InternalProjectId)this.serviceInfo.getInternalId());
    }
}

