/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.RelatedIssuesTreeMapNode;
import com.teamscale.service.metrics.treemap.TreemapSummaryQueryOptions;
import com.teamscale.service.metrics.treemap.builder.NumericValueTreeMapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.TreemapSummaryUtils;
import com.teamscale.wia.TeamscaleIssueId;
import java.awt.Color;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.SetMap;

public class IssueTreemapBuilder
extends NumericValueTreeMapBuilderBase<Integer, RelatedIssuesTreeMapNode> {
    private final SetMap<String, TeamscaleIssueId> issuesByPath;
    private final Set<String> uniformPaths;
    private final boolean excludeNonReferencedFiles;
    private final TreemapSummaryQueryOptions treemapSummaryParameters;
    private Object metricOverAll;
    private Object metricOverIssueReferenced;

    public IssueTreemapBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, Object colorMetricDefault, Color baseColor, SetMap<String, TeamscaleIssueId> issuesByPath, Set<String> uniformPaths, boolean excludeNonReferencedFiles, TreemapSummaryQueryOptions treemapSummaryParameters) {
        super(includePattern, excludePattern, historyAccessOption, metricRetrievalStrategy, areaMetricIndex, colorMetricDefault, baseColor, 0.0, -1.0, false);
        this.issuesByPath = issuesByPath;
        this.uniformPaths = uniformPaths;
        this.excludeNonReferencedFiles = excludeNonReferencedFiles;
        this.treemapSummaryParameters = treemapSummaryParameters;
    }

    @Override
    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) {
        DoubleSummaryStatistics aggregatedOverAll = new DoubleSummaryStatistics();
        DoubleSummaryStatistics aggregatedOverIssueReferenced = new DoubleSummaryStatistics();
        for (MetricDirectoryEntry entry : entries) {
            if (entry.hasChildren()) continue;
            Double areaMetricValue = (Double)entry.getValueOrDefault(this.areaMetricIndex, (Object)0.0);
            int issueCount = ((Set)this.issuesByPath.getCollectionOrEmpty((Object)entry.getUniformPath())).size();
            DoubleSummaryStatistics statisticsToAdd = TreemapSummaryUtils.calculateStatisticsToAdd(this.treemapSummaryParameters.getSummaryType(), this.treemapSummaryParameters.getViolationThreshold(), false, issueCount, areaMetricValue);
            aggregatedOverAll.combine(statisticsToAdd);
            if (issueCount <= 0) continue;
            aggregatedOverIssueReferenced.combine(statisticsToAdd);
        }
        this.metricOverAll = aggregatedOverAll.getAverage();
        this.metricOverIssueReferenced = aggregatedOverIssueReferenced.getAverage();
    }

    public Object getMetricOverAll() {
        return this.metricOverAll;
    }

    public Object getMetricOverIssueReferenced() {
        return this.metricOverIssueReferenced;
    }

    @Override
    protected List<MetricDirectoryEntry> filterEntries(List<MetricDirectoryEntry> entries, String rootPath) {
        if (this.excludeNonReferencedFiles) {
            return this.filterByIncludeExcludePattern(entries, rootPath);
        }
        return super.filterEntries(entries, rootPath);
    }

    @Override
    protected boolean isIncluded(String uniformPath) {
        if (this.excludeNonReferencedFiles && (!this.issuesByPath.containsCollection((Object)uniformPath) || ((Set)this.issuesByPath.getCollection((Object)uniformPath)).isEmpty())) {
            return false;
        }
        return super.isIncluded(uniformPath);
    }

    @Override
    protected RelatedIssuesTreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        return new RelatedIssuesTreeMapNode(entry.getUniformPath(), (Set)this.issuesByPath.getCollectionOrEmpty((Object)entry.getUniformPath()), entry.getDoubleValue(this.areaMetricIndex), this.formatMetricValue(entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault)), this.determineColor(entry));
    }

    @Override
    protected @Nullable Color determineColor(MetricDirectoryEntry entry) throws StorageException {
        if (entry.hasChildren()) {
            return null;
        }
        if (((Set)this.issuesByPath.getCollectionOrEmpty((Object)entry.getUniformPath())).isEmpty()) {
            return Color.GRAY;
        }
        return super.determineColor(entry);
    }

    @Override
    protected Map<String, Integer> calculateValues(String pathPrefix) {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (String uniformPath : this.uniformPaths) {
            values.put(uniformPath, ((Set)this.issuesByPath.getCollectionOrEmpty((Object)uniformPath)).size());
        }
        return values;
    }
}

