/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues.jira.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.issues.jira.synchronization.JiraConnectionConfiguration;
import com.teamscale.index.issues.jira.synchronization.JiraGlobalCacheIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Path(value="api/jira/debug/global-cache")
public class DebugJiraGlobalCacheService
extends ApiBase {
    @GET
    @Operation(summary="Returns an overview of the content in the global Jira cache index", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public List<JiraConnectionConfiguration> getCacheInformation() throws StorageException {
        JiraGlobalCacheIndex index = this.openGlobalIndex(JiraGlobalCacheIndex.class);
        List allConfigurations = index.getAllConfigurations();
        allConfigurations.forEach(JiraConnectionConfiguration::anonymizePassword);
        return allConfigurations;
    }

    @GET
    @Path(value="{configurationId}")
    @Operation(summary="Returns a list of all ticket ids known for a configuration id.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public List<String> getConfigurationInformation(@PathParam(value="configurationId") int configurationId) throws StorageException {
        JiraGlobalCacheIndex index = this.openGlobalIndex(JiraGlobalCacheIndex.class);
        return index.getAllStoredIssueIds(configurationId);
    }

    @DELETE
    @Operation(summary="Clears the entire global Jira cache", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void clearCache() throws StorageException {
        StorageUtils.clearStore((IStore)this.getGlobalStorageSystem().openStore("jira-global-cache"));
    }

    @DELETE
    @Path(value="{configurationId}")
    @Operation(summary="Clears the global Jira cache for the given configuration id", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void clearCache(@PathParam(value="configurationId") int configurationId) throws StorageException {
        JiraGlobalCacheIndex index = this.openGlobalIndex(JiraGlobalCacheIndex.class);
        index.clearForConfigurationId(configurationId);
    }
}

