/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.option;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.HashedPasswordOptionUtils;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.PasswordOptionUtils;
import com.teamscale.core.option.ScheduleOptionUtils;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public abstract class OptionServiceBase
extends ApiBase {
    protected void editOption(OptionRegistryBase registry, byte[] optionJson, String optionCategory, String optionId, boolean saveIfValidationFails, OptionIndexBase index) throws StorageException {
        Pair optionIdAndSelector = OptionRegistryBase.extractOptionNameAndSelector((String)optionId);
        OptionDescriptor descriptor = OptionServiceBase.getOptionDescriptor(registry, (Pair<String, String>)optionIdAndSelector);
        Optional<IOption> existingOption = OptionServiceBase.getExistingOption(registry, optionCategory, index, (Pair<String, String>)optionIdAndSelector, descriptor);
        try {
            IOption newOption = this.parseOption(saveIfValidationFails, optionJson, descriptor, existingOption.orElse(null));
            registry.putOption(optionCategory, (String)optionIdAndSelector.getFirst(), (String)optionIdAndSelector.getSecond(), newOption, index);
            newOption.executedActionsAfterModification(this.getIndexLayer());
        }
        catch (OptionParsingException e) {
            throw new BadRequestException("Could not parse the given option: " + e.getMessage(), (Throwable)e);
        }
    }

    private static @NonNull OptionDescriptor getOptionDescriptor(OptionRegistryBase registry, Pair<String, String> optionIdAndSelector) {
        OptionDescriptor descriptor = registry.getOptionDescriptor((String)optionIdAndSelector.getFirst());
        if (descriptor == null) {
            throw new NotFoundException("No descriptor for option " + (String)optionIdAndSelector.getFirst() + " found!");
        }
        return descriptor;
    }

    private static Optional<IOption> getExistingOption(OptionRegistryBase registry, String optionCategory, OptionIndexBase index, Pair<String, String> optionIdAndSelector, OptionDescriptor descriptor) throws StorageException {
        if (OptionRegistryBase.containsOptionValue((String)optionCategory, (String)((String)optionIdAndSelector.getFirst()), (String)((String)optionIdAndSelector.getSecond()), (OptionIndexBase)index)) {
            return Optional.of(registry.getOption(optionCategory, (String)optionIdAndSelector.getFirst(), (String)optionIdAndSelector.getSecond(), descriptor.getOptionClass(), index));
        }
        return Optional.empty();
    }

    private IOption parseOption(boolean saveIfValidationFails, byte[] optionJson, OptionDescriptor descriptor, @Nullable IOption existingOption) throws OptionParsingException, StorageException {
        String validationError;
        IOption option;
        try {
            option = (IOption)JsonUtils.deserializeFromJson((String)StringUtils.bytesToString((byte[])optionJson), (Class)descriptor.getOptionClass());
        }
        catch (JsonSerializationException e) {
            throw new OptionParsingException("Could not process option: " + e.getMessage(), e);
        }
        String scheduleParsingError = ScheduleOptionUtils.validateScheduleOptions((IOption)option);
        if (scheduleParsingError != null) {
            throw new OptionParsingException(scheduleParsingError);
        }
        PasswordOptionUtils.unmaskPasswords((IOption)option, (IOption)existingOption);
        option.integrateExistingOption(existingOption);
        HashedPasswordOptionUtils.hashPasswords((IOption)option);
        if (!saveIfValidationFails && (validationError = option.validate((IStorageInfo)this.serviceInfo, this.serviceInfo.getServerConfiguration().toInstanceConfiguration())) != null) {
            throw new OptionParsingException("Invalid option value: " + validationError);
        }
        return option;
    }

    protected IOption getSingleOption(String optionCategory, String optionName, OptionIndexBase index, OptionRegistryBase registry) throws StorageException {
        Pair optionNameAndSelector = OptionRegistryBase.extractOptionNameAndSelector((String)optionName);
        OptionDescriptor descriptor = registry.getOptionDescriptor((String)optionNameAndSelector.getFirst());
        if (descriptor == null) {
            throw new NotFoundException("Unknown option name: " + (String)optionNameAndSelector.getFirst());
        }
        return registry.getOption(optionCategory, (String)optionNameAndSelector.getFirst(), (String)optionNameAndSelector.getSecond(), descriptor.getOptionClass(), index);
    }

    protected void deleteOption(OptionRegistryBase registry, String optionCategory, String optionId, OptionIndexBase index) throws StorageException {
        OptionDescriptor descriptor;
        Pair optionIdAndSelector = OptionRegistryBase.extractOptionNameAndSelector((String)optionId);
        Optional<IOption> existingOption = OptionServiceBase.getExistingOption(registry, optionCategory, index, (Pair<String, String>)optionIdAndSelector, descriptor = OptionServiceBase.getOptionDescriptor(registry, (Pair<String, String>)optionIdAndSelector));
        if (existingOption.isPresent()) {
            existingOption.get().executedActionsBeforeDeletion(this.getIndexLayer(), optionId);
        }
        OptionServiceBase.removeOptionFromRegistry(optionCategory, (ImmutablePair<String, String>)optionIdAndSelector, index);
    }

    private static void removeOptionFromRegistry(String optionCategory, ImmutablePair<String, String> optionIdAndSelector, OptionIndexBase index) throws StorageException {
        OptionRegistryBase.removeOption((String)optionCategory, (String)((String)optionIdAndSelector.getFirst()), (String)((String)optionIdAndSelector.getSecond()), (OptionIndexBase)index);
    }

    private static class OptionParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private OptionParsingException(String message) {
            super(message);
        }

        private OptionParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

