/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/project-ids")
public class ProjectIdResolutionService
extends ApiBase {
    @GET
    @RequiresNoPermission(description="Only projects visible to the user are returned.")
    @Operation(summary="Get project IDs", tags={"Project"}, description="Returns available internal and public project IDs, grouped by primary public ID.")
    public Map<PublicProjectId, ProjectIdEntry> getProjectIdMap() throws StorageException {
        return this.getPermissions().getVisibleProjects(true, true).stream().collect(Collectors.toMap(ProjectInfo::getPrimaryPublicId, info -> new ProjectIdEntry(info.getInternalId(), (List<PublicProjectId>)info.getPublicIds())));
    }

    @GET
    @Path(value="{projectId}")
    @RequiresNoPermission(description="Only projects visible to the user are resolved.")
    @Operation(summary="Get project IDs", tags={"Project"}, description="Returns all public project IDs associated with the given ID.")
    public List<PublicProjectId> getPublicIds(@PathParam(value="projectId") IProjectId projectId) throws StorageException {
        return this.resolveProject(projectId).getPublicIds();
    }

    @GET
    @Path(value="{projectId}/internal")
    @RequiresNoPermission(description="Only projects visible to the user are resolved.")
    @Operation(summary="Get internal project ID", tags={"Project"}, description="Returns the internal project ID associated with the given ID.")
    public InternalProjectId getInternalId(@PathParam(value="projectId") IProjectId projectId) throws StorageException {
        return this.resolveProject(projectId).getInternalId();
    }

    private ProjectInfo resolveProject(IProjectId projectId) throws StorageException {
        if (!this.getPermissions().mayReadProject(projectId)) {
            throw new NotFoundException("Project %s doesn't exist or you don\u2019t have the necessary permissions!".formatted(projectId));
        }
        return this.openGlobalIndex(ProjectIndex.class).resolveProject(projectId);
    }

    public static class ProjectIdEntry {
        @JsonProperty(value="internalId")
        private final InternalProjectId internalProjectId;
        @JsonProperty(value="publicIds")
        private final List<PublicProjectId> publicProjectIds;

        private ProjectIdEntry(InternalProjectId internalProjectId, List<PublicProjectId> publicProjectIds) {
            this.internalProjectId = internalProjectId;
            this.publicProjectIds = publicProjectIds;
        }
    }
}

