/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.quality_report.QualityArtifactParameters;
import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.QualityReportsIndex;
import com.teamscale.index.quality_report.retrospective.Retrospective;
import com.teamscale.index.quality_report.retrospective.RetrospectiveIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import com.teamscale.service.reports.QualityArtifactServiceBase;
import com.teamscale.service.reports.QualityReportsService;
import com.teamscale.service.reports.QualityRetrospectiveValidator;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/retrospectives")
public class RetrospectiveService
extends QualityArtifactServiceBase<Retrospective> {
    @Context
    private ResourceContext resourceContext;

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service will only return retrospectives visible to the current user.")
    @Operation(summary="Get quality retrospectives", description="Returns all retrospectives stored for the given project.", tags={"Reporting"})
    public List<UserResolvedRetrospective> getRetrospectivesForProject(@Parameter(description="The project id") @QueryParam(value="project-id") PublicProjectId projectId) throws StorageException {
        List visibleRetrospectives = PermissionFilterUtils.getVisibleRetrospectives(this.getPermissions(), this.openQualityArtifactIndex());
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        QualityReportsIndex qualityReportsIndex = this.openGlobalIndex(QualityReportsIndex.class);
        return CollectionUtils.filterAndMapWithException(visibleRetrospectives, retrospective -> RetrospectiveService.shouldIncludeRetrospective(projectId, retrospective), retrospective -> RetrospectiveService.wrapInUserResolvedRetrospective(retrospective, userAliasLookup, qualityReportsIndex));
    }

    private static boolean shouldIncludeRetrospective(PublicProjectId projectId, Retrospective retrospective) {
        HashSet referencedProjects = new HashSet(retrospective.getReferencedProjects());
        return projectId == null || referencedProjects.contains(projectId);
    }

    @GET
    @Path(value="{id}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.RETROSPECTIVES, permissions={EBasicPermission.VIEW}, entityPathParameter="id")
    @Operation(summary="Get retrospective", description="Returns the retrospective.", tags={"Reporting"})
    public UserResolvedRetrospective getRetrospective(@Parameter(description="The retrospective id") @PathParam(value="id") String retrospectiveId) throws StorageException {
        QualityReportsIndex qualityReportsIndex = this.openGlobalIndex(QualityReportsIndex.class);
        return RetrospectiveService.wrapInUserResolvedRetrospective((Retrospective)this.getElementWithExistsCheck(retrospectiveId), UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()), qualityReportsIndex);
    }

    @GET
    @Path(value="{id}/notes/{projectId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.RETROSPECTIVES, permissions={EBasicPermission.EDIT}, entityPathParameter="id")
    @Operation(summary="Get retrospective notes", description="Returns the retrospective notes for the given project.")
    public String getRetrospectiveNote(@Parameter(description="The ID of the retrospective to get notes for.") @PathParam(value="id") String retrospectiveId, @PathParam(value="projectId") PublicProjectId projectId) throws StorageException {
        return ((Retrospective)this.getElementWithExistsCheck(retrospectiveId)).getNotes().getOrDefault(projectId, "");
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_RETROSPECTIVES})
    @Operation(summary="Create quality retrospective", description="Creates a new quality retrospective either from scratch or by copying an existing retrospective.", tags={"Reporting"})
    public String createRetrospective(@RequestBody(required=true) QualityArtifactParameters retroParameters, @Parameter(description="The id of the retrospective to be copied/overwritten") @QueryParam(value="from-template") String templateRetrospectiveId) throws StorageException {
        Retrospective retrospective;
        if (templateRetrospectiveId != null) {
            this.getPermissions().checkBasicPermission(this.getPermissionScope(), templateRetrospectiveId, EBasicPermission.EDIT);
            retrospective = (Retrospective)this.copyQualityArtifact(templateRetrospectiveId, retroParameters);
        } else {
            retrospective = retroParameters.createRetrospective(null, DateTimeUtils.millisNow(), this.getUser().getUsername(), new HashMap());
        }
        this.createElementAndPermissions(retrospective);
        return retrospective.getMetaInfo().getId();
    }

    @PUT
    @Path(value="{id}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.RETROSPECTIVES, permissions={EBasicPermission.EDIT}, entityPathParameter="id")
    @Operation(summary="Update retrospective", description="Updates an existing retrospective.")
    public void updateRetrospective(@Parameter(description="The id of the retrospective that gets an update.") @PathParam(value="id") String retrospectiveId, @RequestBody(required=true) QualityArtifactParameters retroParameters) throws StorageException {
        QualityReport associatedReport;
        Retrospective oldRetrospective = (Retrospective)this.getElementWithExistsCheck(retrospectiveId);
        Retrospective newRetrospective = retroParameters.createRetrospective(oldRetrospective.getMetaInfo().getId(), oldRetrospective.getMetaInfo().getCreationTimestamp(), oldRetrospective.getMetaInfo().getAuthor(), oldRetrospective.getNotes());
        QualityRetrospectiveValidator.getValidator(newRetrospective, this.serviceInfo).validateOrThrow();
        QualityReportsIndex qualityReportsIndex = this.openGlobalIndex(QualityReportsIndex.class);
        if (retroParameters.linkedArtifactId() != null && (associatedReport = qualityReportsIndex.getById(retroParameters.linkedArtifactId())) != null) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.REPORTS, associatedReport.getMetaInfo().getId(), EBasicPermission.EDIT);
            QualityArtifactParameters newReportParameters = retroParameters.withNameAndLink("Report for " + retroParameters.name(), retrospectiveId);
            QualityReportsService reportService = (QualityReportsService)this.resourceContext.getResource(QualityReportsService.class);
            reportService.updateQualityReport(associatedReport.getMetaInfo().getId(), newReportParameters);
        }
        this.updateElement(oldRetrospective, newRetrospective);
    }

    @PUT
    @Path(value="{id}/notes/{projectId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.RETROSPECTIVES, permissions={EBasicPermission.EDIT}, entityPathParameter="id")
    @Operation(summary="Update retrospective notes", description="Updates an existing note for a project in a retrospective.")
    public void updateRetrospectiveNote(@Parameter(description="The ID of the retrospective that gets an update.") @PathParam(value="id") String retrospectiveId, @PathParam(value="projectId") PublicProjectId projectId, @RequestBody(required=true) String notes) throws StorageException {
        Retrospective retrospective = (Retrospective)this.getElementWithExistsCheck(retrospectiveId);
        retrospective.setNote(projectId, notes);
        this.updateElement(retrospective, retrospective);
    }

    private static @NonNull UserResolvedRetrospective wrapInUserResolvedRetrospective(Retrospective retrospective, UserAliasLookup userAliasLookup, QualityReportsIndex qualityReportsIndex) throws StorageException {
        if (retrospective.getReportId() != null && qualityReportsIndex.getById(retrospective.getReportId()) == null) {
            retrospective.setReportId(null);
        }
        return new UserResolvedRetrospective(retrospective, userAliasLookup.resolveUser(retrospective.getMetaInfo().getAuthor()).orElse(null));
    }

    @DELETE
    @Path(value="{id}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.RETROSPECTIVES, permissions={EBasicPermission.DELETE}, entityPathParameter="id")
    @Operation(summary="Delete quality retrospective", description="Deletes an existing quality retrospective.", tags={"Reporting"})
    public void deleteRetrospective(@Parameter(description="The ID of the retrospective that should be deleted.") @PathParam(value="id") String retrospectiveId) throws StorageException {
        this.deleteElementAndPermissions((Retrospective)this.getElementWithExistsCheck(retrospectiveId));
    }

    protected RetrospectiveIndex openQualityArtifactIndex() throws StorageException {
        return this.openGlobalIndex(RetrospectiveIndex.class);
    }

    @Override
    protected void checkMayCreateQualityArtifact(QualityArtifactParameters tempQualityArtifact) {
    }

    @Override
    protected Retrospective createQualityArtifactCopy(QualityArtifactParameters artifactParameters, Retrospective existingRetrospective) {
        return artifactParameters.createRetrospective(null, DateTimeUtils.millisNow(), this.getUser().getUsername(), existingRetrospective.getNotes());
    }

    @Override
    protected EBasicPermissionScope getPermissionScope() {
        return EBasicPermissionScope.RETROSPECTIVES;
    }

    public record UserResolvedRetrospective(@JsonUnwrapped Retrospective retrospective, @JsonProperty(value="user") @Nullable User user) {
    }
}

