/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.user.User;
import com.teamscale.index.quality_report.slides.MetricTreemapSlide;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.TreemapService;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import java.awt.Color;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class MetricTreemapSlideRenderer
extends SlideRendererBase<MetricTreemapSlide.MetricTreemapSlideParameters> {
    public MetricTreemapSlideRenderer(SlideRenderContext<MetricTreemapSlide.MetricTreemapSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public MetricTreemapSlide.MetricTreemapSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        MetricTreemapSlide.MetricTreemapSlideResult existingSlideRenderData;
        if (existingSlide != null && (existingSlideRenderData = (MetricTreemapSlide.MetricTreemapSlideResult)existingSlide.rawRenderData()) != null && this.areTreemapDataParametersEqual((MetricTreemapSlide.MetricTreemapSlideParameters)existingSlide.slide().getSlideParameters(), (MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters())) {
            return new MetricTreemapSlide.MetricTreemapSlideResult(existingSlideRenderData.getTreemap(), this.getSlideCommentRenderData(((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getProjectBranchPath(), ((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getComments()));
        }
        try {
            return new MetricTreemapSlide.MetricTreemapSlideResult(this.loadTreemapData(), this.getSlideCommentRenderData(((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getProjectBranchPath(), ((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getComments()));
        }
        catch (TreeMapBuilderException e) {
            throw new AssertionError("Failed to render treemap: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    private boolean areTreemapDataParametersEqual(MetricTreemapSlide.MetricTreemapSlideParameters p1, MetricTreemapSlide.MetricTreemapSlideParameters p2) {
        return Objects.equals(p1.getProjectBranchPath(), p2.getProjectBranchPath()) && Objects.equals(p1.getColorMetricName(), p2.getColorMetricName()) && Objects.equals(p1.getAreaMetricName(), p2.getAreaMetricName()) && Objects.equals(p1.getColor(), p2.getColor()) && Objects.equals(p1.getMinValue(), p2.getMinValue()) && Objects.equals(p1.getMaxValue(), p2.getMaxValue()) && Objects.equals(p1.getIncludePattern(), p2.getIncludePattern()) && Objects.equals(p1.getExcludePattern(), p2.getExcludePattern());
    }

    private TreeMapNode loadTreemapData() throws StorageException, TreeMapBuilderException {
        ProjectBranchPath projectBranchPath = ((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getProjectBranchPath();
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)projectBranchPath.getPath());
        IStorageInfo projectAwareStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(projectBranchPath);
        String branch = ReportUtils.determineBranch(projectAwareStorageInfo, projectBranchPath);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)branch, (long)this.getReportProfile().getEndWithType().getTimestamp());
        ProjectStorageSystem projectStorageSystem = this.renderContext.getProjectStorageSystem(projectBranchPath.getProjectId());
        MetricDirectorySchema metricDirectorySchema = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)this.renderContext.getGlobalStorageSystem(), (User)this.renderContext.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory(projectStorageSystem)).getMetricDirectorySchema();
        TreemapQueryOptions treemapParameters = new TreemapQueryOptions();
        treemapParameters.areaMetricIndex = metricDirectorySchema.getValuePosition(((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getAreaMetricName());
        treemapParameters.colorMetricIndex = metricDirectorySchema.getValuePosition(((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getColorMetricName());
        treemapParameters.baseColorValue = Color.decode(((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getColor());
        treemapParameters.specifiedMinValue = ((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getMinValue();
        treemapParameters.specifiedMaxValue = ((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getMaxValue();
        treemapParameters.includePatternStrings = StringUtils.splitLinesAsList((String)((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getIncludePattern());
        treemapParameters.excludePatternStrings = StringUtils.splitLinesAsList((String)((MetricTreemapSlide.MetricTreemapSlideParameters)this.getParameters()).getExcludePattern());
        treemapParameters.adjustTreemapRequestOptions(metricDirectorySchema, true);
        return TreemapService.computeAndLayoutTreemapNode(treemapParameters, uniformPath, historyAccessOption, projectStorageSystem, this.renderContext.getGlobalStorageSystem(), this.renderContext.getUser());
    }
}

