/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.TestGapSlidePartitionSelector;
import com.teamscale.index.quality_report.slides.TestGapTreemapSlide;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.treemap.TestGapTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TgaTreeMapService;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class TestGapTreemapSlideRenderer
extends SlideRendererBase<TestGapTreemapSlide.TestGapTreemapSlideParameters> {
    public TestGapTreemapSlideRenderer(SlideRenderContext<TestGapTreemapSlide.TestGapTreemapSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public TestGapTreemapSlide.TestGapTreemapSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        TestGapTreemapSlide.TestGapTreemapSlideResult existingSlideRenderData;
        if (existingSlide != null && (existingSlideRenderData = (TestGapTreemapSlide.TestGapTreemapSlideResult)existingSlide.rawRenderData()) != null && TestGapTreemapSlideRenderer.areTreemapDataParametersEqual((TestGapTreemapSlide.TestGapTreemapSlideParameters)((TestGapTreemapSlide)existingSlide.slide()).getSlideParameters(), (TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters())) {
            return new TestGapTreemapSlide.TestGapTreemapSlideResult(existingSlideRenderData.getTreemapWrapper(), this.getSlideCommentRenderData(((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getProjectBranchPath(), ((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getComments()));
        }
        return new TestGapTreemapSlide.TestGapTreemapSlideResult(this.loadTreemapData(), this.getSlideCommentRenderData(((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getProjectBranchPath(), ((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getComments()));
    }

    private static boolean areTreemapDataParametersEqual(TestGapTreemapSlide.TestGapTreemapSlideParameters p1, TestGapTreemapSlide.TestGapTreemapSlideParameters p2) {
        return Objects.equals(p1.getProjectBranchPath(), p2.getProjectBranchPath()) && Objects.equals(p1.getPartitionSelector(), p2.getPartitionSelector()) && p1.getTreemapDisplayMode() == p2.getTreemapDisplayMode();
    }

    private TestGapTreemapSlide.TreemapWrapper loadTreemapData() throws StorageException {
        ProjectBranchPath projectBranchPath = ((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getProjectBranchPath();
        IStorageInfo projectAwareStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(projectBranchPath);
        ETgaAssessmentType assessmentType = ETgaAssessmentType.TEST_GAP;
        boolean hideUnchangedMethods = false;
        TestGapTreemapSlide.ETreemapDisplayMode setMode = ((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getTreemapDisplayMode();
        if (setMode == TestGapTreemapSlide.ETreemapDisplayMode.HIDE_UNCHANGED_METHODS) {
            hideUnchangedMethods = true;
        } else if (setMode == TestGapTreemapSlide.ETreemapDisplayMode.SHOW_EXECUTION) {
            assessmentType = ETgaAssessmentType.EXECUTION_ONLY;
        }
        List<PublicProjectId> crossAnnotationProjects = this.getAllowedCrossAnnotationProjects();
        TestGapSlidePartitionSelector slidePartitionSelector = ((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getPartitionSelector();
        List coverageSources = slidePartitionSelector.coverageSources();
        boolean useAllPartitions = slidePartitionSelector.allPartitionsSelected();
        CoverageSourceQueryParameters coverageParameters = new CoverageSourceQueryParameters(CollectionUtils.map(crossAnnotationProjects, ProjectIdBase::toString), coverageSources, useAllPartitions);
        long baseline = this.getReportProfile().getBaselineWithType().getTimestamp();
        String branch = ReportUtils.determineBranch(projectAwareStorageInfo, projectBranchPath);
        CommitDescriptor endCommit = new CommitDescriptor(branch, this.getReportProfile().getEndWithType().getTimestamp());
        TgaPathRequest tgaRequest = new TgaPathRequest(projectBranchPath.getPath(), baseline, endCommit, (CoverageSourceParameterBase)coverageParameters, assessmentType, (IProjectId)projectBranchPath.getProjectId(), this.renderContext.getIndexLayer());
        TestGapTreeMapWrapper treemapWrapper = TgaTreeMapService.getTestGapTreemapWrapperFromTreemapRequest((ITgaRequest)tgaRequest, hideUnchangedMethods, UniformPathCompatibilityUtil.convert((String)projectBranchPath.getPath()));
        return new TestGapTreemapSlide.TreemapWrapper(treemapWrapper.getTreemap(), treemapWrapper.getStateCounter(), treemapWrapper.getRatio().doubleValue(), treemapWrapper.getUsedPartitions(), treemapWrapper.getUsedCrossAnnotationProjects(), baseline);
    }

    private List<PublicProjectId> getAllowedCrossAnnotationProjects() throws StorageException {
        ArrayList<PublicProjectId> crossAnnotationProjects = new ArrayList<PublicProjectId>();
        for (PublicProjectId project : ((TestGapTreemapSlide.TestGapTreemapSlideParameters)this.getParameters()).getPartitionSelector().crossAnnotationProjects()) {
            if (!this.renderContext.getPermissions().mayReadProject((IProjectId)project)) continue;
            crossAnnotationProjects.add(project);
        }
        return crossAnnotationProjects;
    }
}

