/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitRepositoryConnector;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnector;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnector;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnector;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.gitea.GiteaRepositoryConnector;
import com.teamscale.index.repository.git.gitea.GiteaRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnector;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.gitlab.GitLabRepositoryConnector;
import com.teamscale.index.repository.git.gitlab.GitLabRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.scm_manager.ScmManagerRepositoryConnector;
import com.teamscale.index.repository.git.scm_manager.ScmManagerRepositoryConnectorDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;

public abstract class GitRepositoryConnectorUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull GitRepositoryConnector createGitRepositoryConnector(GitRepositoryConnectorDescriptor repositoryConnectorDescriptor, GitRepositoryInfoIndex gitInfoIndex, PublicProjectId projectId, String repositoryId, IndexLayer indexLayer) throws StorageException, ConnectorValidationException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        GitIndices gitIndices = GitRepositoryConnectorUtils.getGitIndices(gitInfoIndex, projectStorageSystem, repositoryConnectorDescriptor.getConnectorIdentifier(), indexLayer);
        IBranchingLayer branchPointerIndexBranchingLayer = GitRepositoryConnectorUtils.openBranchPointerIndexBranchingLayer(projectStorageSystem, repositoryId);
        return GitRepositoryConnectorUtils.createGitRepositoryConnector(repositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer, indexLayer);
    }

    private static @NonNull GitRepositoryConnector createGitRepositoryConnector(GitRepositoryConnectorDescriptor repositoryConnectorDescriptor, GitIndices gitIndices, IBranchingLayer branchPointerIndexBranchingLayer, IndexLayer indexLayer) throws ConnectorValidationException, StorageException {
        if (repositoryConnectorDescriptor instanceof GitLabRepositoryConnectorDescriptor) {
            GitLabRepositoryConnectorDescriptor gitLabRepositoryConnectorDescriptor = (GitLabRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new GitLabRepositoryConnector(gitLabRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        if (repositoryConnectorDescriptor instanceof GitHubRepositoryConnectorDescriptor) {
            GitHubRepositoryConnectorDescriptor gitHubRepositoryConnectorDescriptor = (GitHubRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new GitHubRepositoryConnector(gitHubRepositoryConnectorDescriptor, (GitHubInstallationIndex)indexLayer.openGlobalIndex(GitHubInstallationIndex.class), (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class), (AccessTokenIndex)indexLayer.openGlobalIndex(AccessTokenIndex.class), gitIndices, branchPointerIndexBranchingLayer, LOGGER);
        }
        if (repositoryConnectorDescriptor instanceof BitbucketServerRepositoryConnectorDescriptor) {
            BitbucketServerRepositoryConnectorDescriptor bitbucketServerRepositoryConnectorDescriptor = (BitbucketServerRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new BitbucketServerRepositoryConnector(bitbucketServerRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        if (repositoryConnectorDescriptor instanceof BitbucketCloudRepositoryConnectorDescriptor) {
            BitbucketCloudRepositoryConnectorDescriptor bitbucketCloudRepositoryConnectorDescriptor = (BitbucketCloudRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new BitbucketCloudRepositoryConnector(bitbucketCloudRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        if (repositoryConnectorDescriptor instanceof ScmManagerRepositoryConnectorDescriptor) {
            ScmManagerRepositoryConnectorDescriptor scmManagerRepositoryConnectorDescriptor = (ScmManagerRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new ScmManagerRepositoryConnector(scmManagerRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        if (repositoryConnectorDescriptor instanceof AzureDevOpsGitRepositoryConnectorDescriptor) {
            AzureDevOpsGitRepositoryConnectorDescriptor azureDevOpsGitRepositoryConnectorDescriptor = (AzureDevOpsGitRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new AzureDevOpsGitRepositoryConnector(azureDevOpsGitRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        if (repositoryConnectorDescriptor instanceof GiteaRepositoryConnectorDescriptor) {
            GiteaRepositoryConnectorDescriptor giteaRepositoryConnectorDescriptor = (GiteaRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new GiteaRepositoryConnector(giteaRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        if (repositoryConnectorDescriptor instanceof GerritRepositoryConnectorDescriptor) {
            GerritRepositoryConnectorDescriptor gerritRepositoryConnectorDescriptor = (GerritRepositoryConnectorDescriptor)repositoryConnectorDescriptor;
            return new GerritRepositoryConnector(gerritRepositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
        }
        return new GitRepositoryConnector(repositoryConnectorDescriptor, gitIndices, branchPointerIndexBranchingLayer);
    }

    private static GitIndices getGitIndices(GitRepositoryInfoIndex gitInfoIndex, CommitResolvingStorageSystem projectStorageSystem, String connectorIdentifier, IndexLayer indexLayer) throws StorageException {
        return new GitIndices(gitInfoIndex, (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class), (AccessTokenIndex)indexLayer.openGlobalIndex(AccessTokenIndex.class), (PostponedRollbackIndex)projectStorageSystem.openProjectIndex(PostponedRollbackIndex.class, null), (RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null), (PendingGarbageCollectionIndex)indexLayer.openGlobalIndex(PendingGarbageCollectionIndex.class), GitRepositoryConnectorUtils.openCrossRepositoryMergeRequestSourceBranchesIndex(projectStorageSystem, connectorIdentifier));
    }

    private static IBranchingLayer openBranchPointerIndexBranchingLayer(CommitResolvingStorageSystem projectStorageSystem, String repositoryId) throws StorageException {
        return projectStorageSystem.openBranchingLayer(GitBranchPointerIndex.createIndexName((String)repositoryId), GitBranchPointerIndex.class);
    }

    private static CrossRepositoryMergeRequestSourceBranchesIndex openCrossRepositoryMergeRequestSourceBranchesIndex(CommitResolvingStorageSystem projectStorageSystem, String connectorIdentifier) throws StorageException {
        return (CrossRepositoryMergeRequestSourceBranchesIndex)projectStorageSystem.openProjectIndex(CrossRepositoryMergeRequestSourceBranchesIndex.class, CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName((String)connectorIdentifier), null);
    }

    public static GitRepositoryConnection createGitRepositoryConnection(GitRepositoryConnector connector, IndexLayer indexLayer) throws RepositoryException, StorageException {
        connector.externalCredentialsIndex = (ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        return connector.createConnection(IProfilingMonitor.EMPTY, ICancelable.neverCanceled(), IParallelTaskExecutor.sameThread());
    }
}

