/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeIndexBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/repository/changes")
public class RepositoryChangesService
extends ApiBase {
    @GET
    @Operation(summary="Return all repository changes", description="Returns all changes in the project at the specified commit", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Collection<RepositoryChangeEntry> getChanges(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        ProjectRepositoryChangeIndex repositoryChangeIndex = this.openProjectRepositoryChangeIndex();
        return this.getAllChanges(commit, (RepositoryChangeIndexBase)repositoryChangeIndex);
    }

    @GET
    @Operation(summary="Return all changes in the given repository", description="Returns all changes in the specified repository at the specified commit", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="repository/{repository}")
    public Collection<RepositoryChangeEntry> getRepositoryChanges(@PathParam(value="repository") String repository, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        RepositoryChangeIndex repositoryChangeIndex = this.openSingleRepositoryChangeIndex(repository);
        return this.getAllChanges(commit, (RepositoryChangeIndexBase)repositoryChangeIndex);
    }

    @GET
    @Operation(summary="Return repository changes for path/revision", description="Returns the changes in the project for the specified path at the specified revision", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="revision")
    public Collection<RepositoryChangeEntry> getChangesForRevision(@QueryParam(value="path") @Parameter(required=true) UniformPath path, @QueryParam(value="revision") @Parameter(required=true) String revision, @QueryParam(value="branch") @Parameter(required=true) String branch) throws StorageException {
        ProjectRepositoryChangeIndex repositoryChangeIndex = this.openProjectRepositoryChangeIndex();
        return RepositoryChangesService.getSingleRevisionChanges(path, revision, branch, (RepositoryChangeIndexBase)repositoryChangeIndex);
    }

    @GET
    @Operation(summary="Return repository changes for path/revision in the given repository", description="Returns the changes in the specified repository for the specified path at the specified revision", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="repository/{repository}/revision")
    public Collection<RepositoryChangeEntry> getRepositoryChangesForRevision(@PathParam(value="repository") String repository, @QueryParam(value="path") @Parameter(required=true) UniformPath path, @QueryParam(value="revision") @Parameter(required=true) String revision, @QueryParam(value="branch") @Parameter(required=true) String branch) throws StorageException {
        RepositoryChangeIndex repositoryChangeIndex = this.openSingleRepositoryChangeIndex(repository);
        return RepositoryChangesService.getSingleRevisionChanges(path, revision, branch, (RepositoryChangeIndexBase)repositoryChangeIndex);
    }

    private Collection<RepositoryChangeEntry> getAllChanges(UnresolvedCommitDescriptor commit, RepositoryChangeIndexBase repositoryChangeIndex) throws StorageException {
        if (commit.isDefaultAtHead()) {
            return repositoryChangeIndex.getChanges();
        }
        return repositoryChangeIndex.getEntriesForCommit(this.resolve(commit));
    }

    private static List<RepositoryChangeEntry> getSingleRevisionChanges(UniformPath path, String revision, String branch, RepositoryChangeIndexBase repositoryChangeIndex) throws StorageException {
        return repositoryChangeIndex.getEntries(List.of(RepositoryChangeIndexBase.makeFileKey((UniformPath)path, (String)revision, (String)branch).substring(6)), true);
    }

    private ProjectRepositoryChangeIndex openProjectRepositoryChangeIndex() throws StorageException {
        return this.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
    }

    private RepositoryChangeIndex openSingleRepositoryChangeIndex(String repository) throws StorageException {
        return this.openProjectIndex(RepositoryChangeIndex.class, RepositoryChangeIndex.getIndexName((String)repository), null);
    }
}

