/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.s3;

import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ChangeRetriever;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/s3/force-full-scan")
public class S3ForceFullScanService
extends ApiBase {
    @PUT
    @RequiresProjectPermission(value={EProjectPermission.TRIGGER_COMMIT_HOOK})
    @Operation(summary="Force full scan without cache on all S3 Connectors", description="Triggers a full scan (without cache) on all S3 connections.", tags={"Connectors"})
    @ApiResponse(responseCode="404", description="If no project with the given ID was found.")
    public String scheduleS3WithFullScan(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        ProjectConfiguration projectConfig = this.getProjectConfig(projectId);
        boolean externalStorageScanWasScheduled = this.scheduleExternalStorageFullScan(projectId, projectConfig);
        List<ConnectorConfiguration> s3Connectors = projectConfig.getConnectors().stream().filter(connector -> connector.getType().equals(ERepositoryConnector.S3.getReadableName())).toList();
        if (s3Connectors.isEmpty() && !externalStorageScanWasScheduled) {
            S3ForceFullScanService.throwConnectorNotFoundException(projectId);
        }
        for (ConnectorConfiguration connector2 : s3Connectors) {
            this.scheduleFullScan(projectId, connector2.getIdentifier(), TriggerBuilder.buildTriggerName((String)connector2.getIdentifier(), (String)TriggerBuilder.getSimpleTriggerName(S3ChangeRetriever.class)));
        }
        return "Successfully scheduled a full scan on the S3 change retrievers in project '" + String.valueOf(projectId) + "'.";
    }

    private boolean scheduleExternalStorageFullScan(PublicProjectId projectId, ProjectConfiguration projectConfig) throws StorageException {
        if (projectConfig.getExternalStorageBackend() == null) {
            return false;
        }
        Optional externalStorageBackend = ExternalStorageLookup.getStorageBackend((ProjectConfiguration)projectConfig, (ExternalStorageBackendIndex)this.openGlobalIndex(ExternalStorageBackendIndex.class));
        if (externalStorageBackend.isEmpty()) {
            throw new NotFoundException("External storage '%s' selected in project %s not found.".formatted(projectConfig.getExternalStorageBackend(), projectId));
        }
        if (((ExternalStorageBackend)externalStorageBackend.get()).backendProtocol() != EExternalStorageBackendProtocol.S3) {
            return false;
        }
        this.scheduleFullScan(projectId, "external-analysis-data", ((ExternalStorageBackend)externalStorageBackend.get()).backendProtocol().getChangeRetrieverTriggerName());
        return true;
    }

    private void scheduleFullScan(PublicProjectId projectId, String connectorIdentifier, String changeRetrieverName) throws StorageException {
        S3ArchiveIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (String)connectorIdentifier).runWithIncrementalScanLock(index -> index.setForceFullScan(true));
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.getIndexLayer(), this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId), changeRetrieverName);
    }

    private static void throwConnectorNotFoundException(PublicProjectId projectId) {
        throw new NotFoundException("No S3 connector found in project '" + String.valueOf(projectId) + "'.");
    }

    private ProjectConfiguration getProjectConfig(PublicProjectId projectId) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectId, (IndexLayer)this.getIndexLayer());
        if (projectConfiguration == null) {
            throw new NotFoundException("Project with ID '" + String.valueOf(projectId) + "' was not found.");
        }
        return projectConfiguration;
    }
}

